/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.HashMap;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public class SchemaTranslation {
    private static final BiMap<Schema.TypeName, RunnerApi.Schema.TypeName> TYPE_NAME_MAPPING = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)Schema.TypeName.BYTE, RunnerApi.Schema.TypeName.BYTE)).put((Object)Schema.TypeName.INT16, RunnerApi.Schema.TypeName.INT16)).put((Object)Schema.TypeName.INT32, RunnerApi.Schema.TypeName.INT32)).put((Object)Schema.TypeName.INT64, RunnerApi.Schema.TypeName.INT64)).put((Object)Schema.TypeName.DECIMAL, RunnerApi.Schema.TypeName.DECIMAL)).put((Object)Schema.TypeName.FLOAT, RunnerApi.Schema.TypeName.FLOAT)).put((Object)Schema.TypeName.DOUBLE, RunnerApi.Schema.TypeName.DOUBLE)).put((Object)Schema.TypeName.STRING, RunnerApi.Schema.TypeName.STRING)).put((Object)Schema.TypeName.DATETIME, RunnerApi.Schema.TypeName.DATETIME)).put((Object)Schema.TypeName.BOOLEAN, RunnerApi.Schema.TypeName.BOOLEAN)).put((Object)Schema.TypeName.BYTES, RunnerApi.Schema.TypeName.BYTES)).put((Object)Schema.TypeName.ARRAY, RunnerApi.Schema.TypeName.ARRAY)).put((Object)Schema.TypeName.MAP, RunnerApi.Schema.TypeName.MAP)).put((Object)Schema.TypeName.ROW, RunnerApi.Schema.TypeName.ROW)).put((Object)Schema.TypeName.LOGICAL_TYPE, RunnerApi.Schema.TypeName.LOGICAL_TYPE)).build();

    public static RunnerApi.Schema toProto(Schema schema) {
        String uuid = schema.getUUID() != null ? schema.getUUID().toString() : "";
        RunnerApi.Schema.Builder builder = RunnerApi.Schema.newBuilder().setId(uuid);
        for (Schema.Field field : schema.getFields()) {
            RunnerApi.Schema.Field protoField = SchemaTranslation.toProto(field, schema.indexOf(field.getName()), schema.getEncodingPositions().get(field.getName()));
            builder.addFields(protoField);
        }
        return builder.build();
    }

    private static RunnerApi.Schema.Field toProto(Schema.Field field, int fieldId, int position) {
        return RunnerApi.Schema.Field.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setType(SchemaTranslation.toProto(field.getType())).setId(fieldId).setEncodingPosition(position).build();
    }

    private static RunnerApi.Schema.FieldType toProto(Schema.FieldType fieldType) {
        RunnerApi.Schema.FieldType.Builder builder = RunnerApi.Schema.FieldType.newBuilder().setTypeName((RunnerApi.Schema.TypeName)TYPE_NAME_MAPPING.get((Object)fieldType.getTypeName()));
        switch (fieldType.getTypeName()) {
            case ROW: {
                builder.setRowSchema(SchemaTranslation.toProto(fieldType.getRowSchema()));
                break;
            }
            case ARRAY: {
                builder.setCollectionElementType(SchemaTranslation.toProto(fieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                builder.setMapType(RunnerApi.Schema.MapType.newBuilder().setKeyType(SchemaTranslation.toProto(fieldType.getMapKeyType())).setValueType(SchemaTranslation.toProto(fieldType.getMapValueType())).build());
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                builder.setLogicalType(RunnerApi.Schema.LogicalType.newBuilder().setId(logicalType.getIdentifier()).setArgs(logicalType.getArgument()).setBaseType(SchemaTranslation.toProto(logicalType.getBaseType())).setSerializedClass(ByteString.copyFrom(SerializableUtils.serializeToByteArray(logicalType))).build());
                break;
            }
        }
        builder.setNullable(fieldType.getNullable());
        return builder.build();
    }

    public static Schema fromProto(RunnerApi.Schema protoSchema) {
        Schema.Builder builder = Schema.builder();
        HashMap<String, Integer> encodingLocationMap = Maps.newHashMap();
        for (RunnerApi.Schema.Field protoField : protoSchema.getFieldsList()) {
            Schema.Field field = SchemaTranslation.fieldFromProto(protoField);
            builder.addField(field);
            encodingLocationMap.put(protoField.getName(), protoField.getEncodingPosition());
        }
        Schema schema = builder.build();
        schema.setEncodingPositions(encodingLocationMap);
        if (!protoSchema.getId().isEmpty()) {
            schema.setUUID(UUID.fromString(protoSchema.getId()));
        }
        return schema;
    }

    private static Schema.Field fieldFromProto(RunnerApi.Schema.Field protoField) {
        return Schema.Field.of(protoField.getName(), SchemaTranslation.fieldTypeFromProto(protoField.getType())).withDescription(protoField.getDescription());
    }

    private static Schema.FieldType fieldTypeFromProto(RunnerApi.Schema.FieldType protoFieldType) {
        Schema.FieldType fieldType;
        Schema.TypeName typeName = (Schema.TypeName)((Object)TYPE_NAME_MAPPING.inverse().get(protoFieldType.getTypeName()));
        switch (typeName) {
            case ROW: {
                fieldType = Schema.FieldType.row(SchemaTranslation.fromProto(protoFieldType.getRowSchema()));
                break;
            }
            case ARRAY: {
                fieldType = Schema.FieldType.array(SchemaTranslation.fieldTypeFromProto(protoFieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                fieldType = Schema.FieldType.map(SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getKeyType()), SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getValueType()));
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = (Schema.LogicalType)SerializableUtils.deserializeFromByteArray(protoFieldType.getLogicalType().getSerializedClass().toByteArray(), "logicalType");
                fieldType = Schema.FieldType.logicalType(logicalType);
                break;
            }
            default: {
                fieldType = Schema.FieldType.of(typeName);
            }
        }
        if (protoFieldType.getNullable()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }
}

