/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class WindowIntoTranslation {
    public static RunnerApi.WindowIntoPayload toProto(Window.Assign<?> transform, SdkComponents components) {
        return RunnerApi.WindowIntoPayload.newBuilder().setWindowFn(WindowingStrategyTranslation.toProto(transform.getWindowFn(), components)).build();
    }

    public static RunnerApi.WindowIntoPayload getWindowIntoPayload(AppliedPTransform<?, ?, ?> application) {
        RunnerApi.PTransform transformProto;
        try {
            SdkComponents components = SdkComponents.create(application.getPipeline().getOptions());
            transformProto = PTransformTranslation.toProto(application, Collections.emptyList(), components);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        Preconditions.checkArgument(PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN.equals(transformProto.getSpec().getUrn()), "Illegal attempt to extract %s from transform %s with name \"%s\" and URN \"%s\"", (Object)Window.Assign.class.getSimpleName(), application.getTransform(), (Object)application.getFullName(), (Object)transformProto.getSpec().getUrn());
        try {
            return RunnerApi.WindowIntoPayload.parseFrom(transformProto.getSpec().getPayload());
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalStateException(String.format("%s translated %s with URN '%s' but payload was not a %s", PTransformTranslation.class.getSimpleName(), application, PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, RunnerApi.WindowIntoPayload.class.getSimpleName()), exc);
        }
    }

    @Nullable
    public static WindowFn<?, ?> getWindowFn(AppliedPTransform<?, ?, ?> application) {
        return WindowingStrategyTranslation.windowFnFromProto(WindowIntoTranslation.getWindowIntoPayload(application).getWindowFn());
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(Window.Assign.class, new WindowIntoPayloadTranslator());
        }
    }

    public static class WindowIntoPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Window.Assign<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new WindowIntoPayloadTranslator();
        }

        private WindowIntoPayloadTranslator() {
        }

        @Override
        public String getUrn(Window.Assign<?> transform) {
            return PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Window.Assign<?>> transform, SdkComponents components) {
            RunnerApi.WindowIntoPayload payload = WindowIntoTranslation.toProto(transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }

    static class WindowAssignTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Window.Assign<?>> {
        WindowAssignTranslator() {
        }

        @Override
        public String getUrn(Window.Assign<?> transform) {
            return PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Window.Assign<?>> transform, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:window:v1").setPayload(WindowIntoTranslation.toProto(transform.getTransform(), components).toByteString()).build();
        }
    }
}

