/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

public class WriteFilesTranslation {
    public static final String CUSTOM_JAVA_FILE_BASED_SINK_URN = "beam:file_based_sink:javasdk:0.1";

    @VisibleForTesting
    static RunnerApi.WriteFilesPayload payloadForWriteFiles(final WriteFiles<?, ?, ?> transform, SdkComponents components) throws IOException {
        return WriteFilesTranslation.payloadForWriteFilesLike(new WriteFilesLike(){

            @Override
            public RunnerApi.SdkFunctionSpec translateSink(SdkComponents newComponents) {
                return WriteFilesTranslation.toProto(transform.getSink());
            }

            @Override
            public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView<?> view : transform.getSink().getDynamicDestinations().getSideInputs()) {
                    sideInputs.put(view.getTagInternal().getId(), ParDoTranslation.translateView(view, components));
                }
                return sideInputs;
            }

            @Override
            public boolean isWindowedWrites() {
                return transform.getWindowedWrites();
            }

            @Override
            public boolean isRunnerDeterminedSharding() {
                return transform.getNumShardsProvider() == null && transform.getComputeNumShards() == null;
            }
        }, components);
    }

    private static RunnerApi.SdkFunctionSpec toProto(FileBasedSink<?, ?, ?> sink) {
        return WriteFilesTranslation.toProto(CUSTOM_JAVA_FILE_BASED_SINK_URN, sink);
    }

    private static RunnerApi.SdkFunctionSpec toProto(String urn, Serializable serializable) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(urn).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(serializable))).build()).build();
    }

    @VisibleForTesting
    static FileBasedSink<?, ?, ?> sinkFromProto(RunnerApi.SdkFunctionSpec sinkProto) throws IOException {
        Preconditions.checkArgument(sinkProto.getSpec().getUrn().equals(CUSTOM_JAVA_FILE_BASED_SINK_URN), "Cannot extract %s instance from %s with URN %s", (Object)FileBasedSink.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)sinkProto.getSpec().getUrn());
        byte[] serializedSink = sinkProto.getSpec().getPayload().toByteArray();
        return (FileBasedSink)SerializableUtils.deserializeFromByteArray(serializedSink, FileBasedSink.class.getSimpleName());
    }

    public static <UserT, DestinationT, OutputT> FileBasedSink<UserT, DestinationT, OutputT> getSink(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.sinkFromProto(WriteFilesTranslation.getWriteFilesPayload(transform).getSink());
    }

    public static <UserT, DestinationT> List<PCollectionView<?>> getDynamicDestinationSideInputs(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create(transform.getPipeline().getOptions());
        RunnerApi.PTransform transformProto = PTransformTranslation.toProto(transform, sdkComponents);
        ArrayList<PCollectionView<?>> views = Lists.newArrayList();
        Map<String, RunnerApi.SideInput> sideInputs = WriteFilesTranslation.getWriteFilesPayload(transform).getSideInputsMap();
        for (Map.Entry<String, RunnerApi.SideInput> entry : sideInputs.entrySet()) {
            PCollection originalPCollection = Preconditions.checkNotNull((PCollection)transform.getInputs().get(new TupleTag(entry.getKey())), "no input with tag %s", (Object)entry.getKey());
            views.add(PCollectionViewTranslation.viewFromProto(entry.getValue(), entry.getKey(), originalPCollection, transformProto, RehydratedComponents.forComponents(sdkComponents.toComponents())));
        }
        return views;
    }

    public static <T, DestinationT> boolean isWindowedWrites(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getWindowedWrites();
    }

    public static <T, DestinationT> boolean isRunnerDeterminedSharding(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getRunnerDeterminedSharding();
    }

    private static <T, DestinationT> RunnerApi.WriteFilesPayload getWriteFilesPayload(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        return RunnerApi.WriteFilesPayload.parseFrom(PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    public static RunnerApi.WriteFilesPayload payloadForWriteFilesLike(WriteFilesLike writeFiles, SdkComponents components) throws IOException {
        return RunnerApi.WriteFilesPayload.newBuilder().setSink(writeFiles.translateSink(components)).putAllSideInputs(writeFiles.translateSideInputs(components)).setWindowedWrites(writeFiles.isWindowedWrites()).setRunnerDeterminedSharding(writeFiles.isRunnerDeterminedSharding()).build();
    }

    private static interface WriteFilesLike {
        public RunnerApi.SdkFunctionSpec translateSink(SdkComponents var1);

        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents var1);

        public boolean isWindowedWrites();

        public boolean isRunnerDeterminedSharding();
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<Class<? extends PTransform>, PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(WriteFiles.CONCRETE_CLASS, new WriteFilesTranslator());
        }
    }

    static class WriteFilesTranslator
    implements PTransformTranslation.TransformPayloadTranslator<WriteFiles<?, ?, ?>> {
        WriteFilesTranslator() {
        }

        @Override
        public String getUrn(WriteFiles<?, ?, ?> transform) {
            return PTransformTranslation.WRITE_FILES_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, WriteFiles<?, ?, ?>> transform, SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(WriteFilesTranslation.payloadForWriteFiles(transform.getTransform(), components).toByteString()).build();
        }
    }

    static class RawWriteFiles
    extends PTransformTranslation.RawPTransform<PInput, POutput>
    implements WriteFilesLike {
        private final RunnerApi.PTransform protoTransform;
        private final transient RehydratedComponents rehydratedComponents;
        private final RunnerApi.FunctionSpec spec;
        private final RunnerApi.WriteFilesPayload payload;

        public RawWriteFiles(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            this.rehydratedComponents = rehydratedComponents;
            this.protoTransform = protoTransform;
            this.spec = protoTransform.getSpec();
            this.payload = RunnerApi.WriteFilesPayload.parseFrom(this.spec.getPayload());
        }

        @Override
        public RunnerApi.FunctionSpec getSpec() {
            return this.spec;
        }

        @Override
        public RunnerApi.FunctionSpec migrate(SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.WRITE_FILES_TRANSFORM_URN).setPayload(WriteFilesTranslation.payloadForWriteFilesLike(this, components).toByteString()).build();
        }

        @Override
        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            HashMap additionalInputs = new HashMap();
            for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : this.payload.getSideInputsMap().entrySet()) {
                try {
                    additionalInputs.put(new TupleTag(sideInputEntry.getKey()), this.rehydratedComponents.getPCollection(this.protoTransform.getInputsOrThrow(sideInputEntry.getKey())));
                }
                catch (IOException exc) {
                    throw new IllegalStateException(String.format("Could not find input with name %s for %s transform", sideInputEntry.getKey(), WriteFiles.class.getSimpleName()));
                }
            }
            return additionalInputs;
        }

        @Override
        public RunnerApi.SdkFunctionSpec translateSink(SdkComponents newComponents) {
            return this.payload.getSink();
        }

        @Override
        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
            return MoreObjects.firstNonNull(this.payload.getSideInputsMap(), Collections.emptyMap());
        }

        @Override
        public boolean isWindowedWrites() {
            return this.payload.getWindowedWrites();
        }

        @Override
        public boolean isRunnerDeterminedSharding() {
            return this.payload.getRunnerDeterminedSharding();
        }
    }
}

