/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import javax.annotation.Nullable;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.collect.Iterables;

public class DefaultMetricResults
extends MetricResults {
    private final Iterable<MetricResult<Long>> counters;
    private final Iterable<MetricResult<DistributionResult>> distributions;
    private final Iterable<MetricResult<GaugeResult>> gauges;

    public DefaultMetricResults(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions, Iterable<MetricResult<GaugeResult>> gauges) {
        this.counters = counters;
        this.distributions = distributions;
        this.gauges = gauges;
    }

    @Override
    public MetricQueryResults queryMetrics(@Nullable MetricsFilter filter) {
        return MetricQueryResults.create(Iterables.filter(this.counters, counter -> MetricFiltering.matches(filter, counter.getKey())), Iterables.filter(this.distributions, distribution -> MetricFiltering.matches(filter, distribution.getKey())), Iterables.filter(this.gauges, gauge -> MetricFiltering.matches(filter, gauge.getKey())));
    }
}

