/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;

public class MonitoringInfoMetricName
extends MetricName {
    private String urn;
    private Map<String, String> labels = new HashMap<String, String>();

    private MonitoringInfoMetricName(String urn, Map<String, String> labels) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(urn), "MonitoringInfoMetricName urn must be non-empty");
        Preconditions.checkArgument(labels != null, "MonitoringInfoMetricName labels must be non-null");
        this.urn = urn;
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            this.labels.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getNamespace() {
        if (this.labels.containsKey(MonitoringInfoConstants.Labels.NAMESPACE)) {
            return this.labels.getOrDefault(MonitoringInfoConstants.Labels.NAMESPACE, null);
        }
        return this.urn.split(":", 2)[0];
    }

    @Override
    public String getName() {
        if (this.labels.containsKey(MonitoringInfoConstants.Labels.NAME)) {
            return this.labels.getOrDefault(MonitoringInfoConstants.Labels.NAME, null);
        }
        return this.urn.split(":", 2)[1];
    }

    public String getUrn() {
        return this.urn;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public static MonitoringInfoMetricName of(MetricsApi.MonitoringInfo mi) {
        return new MonitoringInfoMetricName(mi.getUrn(), mi.getLabelsMap());
    }

    public static MonitoringInfoMetricName named(String urn, HashMap<String, String> labels) {
        return new MonitoringInfoMetricName(urn, labels);
    }

    public int hashCode() {
        return Objects.hash(this.urn, this.labels);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringInfoMetricName)) {
            return false;
        }
        MonitoringInfoMetricName other = (MonitoringInfoMetricName)o;
        return this.urn.equals(other.urn) && this.labels.equals(other.labels);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.urn.toString());
        builder.append(" ");
        builder.append(this.labels.toString());
        return builder.toString();
    }
}

