/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.Arrays;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;

public class RepeatedlyStateMachine
extends TriggerStateMachine {
    private static final int REPEATED = 0;

    public static RepeatedlyStateMachine forever(TriggerStateMachine repeated) {
        return new RepeatedlyStateMachine(repeated);
    }

    private RepeatedlyStateMachine(TriggerStateMachine repeated) {
        super(Arrays.asList(repeated));
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        this.getRepeated(c).invokeOnElement(c);
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        this.getRepeated(c).invokeOnMerge(c);
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        return this.getRepeated(context).invokeShouldFire(context);
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        this.getRepeated(context).invokeOnFire(context);
        if (context.trigger().isFinished(0)) {
            context.forTrigger(this.getRepeated(context)).trigger().resetTree();
        }
    }

    @Override
    public String toString() {
        return String.format("Repeatedly.forever(%s)", this.subTriggers.get(0));
    }

    private ExecutableTriggerStateMachine getRepeated(TriggerStateMachine.TriggerContext context) {
        return context.trigger().subTrigger(0);
    }
}

