/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import java.io.IOException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.MetricResults;
import org.joda.time.Duration;

public interface PipelineResult {
    public State getState();

    public State cancel() throws IOException;

    public State waitUntilFinish(Duration var1);

    public State waitUntilFinish();

    @Experimental(value=Experimental.Kind.METRICS)
    public MetricResults metrics();

    public static enum State {
        UNKNOWN(false, false),
        STOPPED(false, false),
        RUNNING(false, false),
        DONE(true, false),
        FAILED(true, false),
        CANCELLED(true, false),
        UPDATED(true, true);

        private final boolean terminal;
        private final boolean hasReplacement;

        private State(boolean terminal, boolean hasReplacement) {
            this.terminal = terminal;
            this.hasReplacement = hasReplacement;
        }

        public final boolean isTerminal() {
            return this.terminal;
        }

        public final boolean hasReplacementJob() {
            return this.hasReplacement;
        }
    }
}

