/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuralByteArray;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.CountingOutputStream;

public abstract class Coder<T>
implements Serializable {
    public abstract void encode(T var1, OutputStream var2) throws CoderException, IOException;

    @Deprecated
    @Experimental(value=Experimental.Kind.CODER_CONTEXT)
    public void encode(T value, OutputStream outStream, Context context) throws CoderException, IOException {
        this.encode(value, outStream);
    }

    public abstract T decode(InputStream var1) throws CoderException, IOException;

    @Deprecated
    @Experimental(value=Experimental.Kind.CODER_CONTEXT)
    public T decode(InputStream inStream, Context context) throws CoderException, IOException {
        return this.decode(inStream);
    }

    public abstract List<? extends Coder<?>> getCoderArguments();

    public abstract void verifyDeterministic() throws NonDeterministicException;

    public static void verifyDeterministic(Coder<?> target, String message, Iterable<Coder<?>> coders) throws NonDeterministicException {
        for (Coder<?> coder : coders) {
            try {
                coder.verifyDeterministic();
            }
            catch (NonDeterministicException e) {
                throw new NonDeterministicException(target, message, e);
            }
        }
    }

    public static void verifyDeterministic(Coder<?> target, String message, Coder<?> ... coders) throws NonDeterministicException {
        Coder.verifyDeterministic(target, message, Arrays.asList(coders));
    }

    public boolean consistentWithEquals() {
        return false;
    }

    public Object structuralValue(T value) {
        if (value != null && this.consistentWithEquals()) {
            return value;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.encode(value, os, Context.OUTER);
            return new StructuralByteArray(os.toByteArray());
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }

    public boolean isRegisterByteSizeObserverCheap(T value) {
        return false;
    }

    public void registerByteSizeObserver(T value, ElementByteSizeObserver observer) throws Exception {
        observer.update(this.getEncodedElementByteSize(value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getEncodedElementByteSize(T value) throws Exception {
        try (CountingOutputStream os = new CountingOutputStream(ByteStreams.nullOutputStream());){
            this.encode(value, os);
            long l = os.getCount();
            return l;
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }

    @Experimental(value=Experimental.Kind.CODER_TYPE_ENCODING)
    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(this.getClass()).resolveType(new TypeDescriptor<T>(){}.getType());
    }

    public static class NonDeterministicException
    extends Exception {
        private Coder<?> coder;
        private List<String> reasons;

        public NonDeterministicException(Coder<?> coder, String reason, @Nullable NonDeterministicException e) {
            this(coder, Arrays.asList(reason), e);
        }

        public NonDeterministicException(Coder<?> coder, String reason) {
            this(coder, Arrays.asList(reason), null);
        }

        public NonDeterministicException(Coder<?> coder, List<String> reasons) {
            this(coder, reasons, null);
        }

        public NonDeterministicException(Coder<?> coder, List<String> reasons, @Nullable NonDeterministicException cause) {
            super(cause);
            Preconditions.checkArgument(reasons.size() > 0, "Reasons must not be empty.");
            this.reasons = reasons;
            this.coder = coder;
        }

        public Iterable<String> getReasons() {
            return this.reasons;
        }

        @Override
        public String getMessage() {
            String reasonsStr = Joiner.on("\n\t").join(this.reasons);
            return this.coder + " is not deterministic because:\n\t" + reasonsStr;
        }
    }

    @Deprecated
    @Experimental(value=Experimental.Kind.CODER_CONTEXT)
    public static class Context {
        public static final Context OUTER = new Context(true);
        public static final Context NESTED = new Context(false);
        public final boolean isWholeStream;

        public Context(boolean isWholeStream) {
            this.isWholeStream = isWholeStream;
        }

        public Context nested() {
            return NESTED;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Context)) {
                return false;
            }
            return Objects.equal(this.isWholeStream, ((Context)obj).isWholeStream);
        }

        public int hashCode() {
            return Objects.hashCode(this.isWholeStream);
        }

        public String toString() {
            return MoreObjects.toStringHelper(Context.class).addValue(this.isWholeStream ? "OUTER" : "NESTED").toString();
        }
    }
}

