/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Objects;

public final class DelegateCoder<T, IntermediateT>
extends CustomCoder<T> {
    private final Coder<IntermediateT> coder;
    private final CodingFunction<T, IntermediateT> toFn;
    private final CodingFunction<IntermediateT, T> fromFn;
    @Nullable
    private final TypeDescriptor<T> typeDescriptor;

    public static <T, IntermediateT> DelegateCoder<T, IntermediateT> of(Coder<IntermediateT> coder, CodingFunction<T, IntermediateT> toFn, CodingFunction<IntermediateT, T> fromFn) {
        return DelegateCoder.of(coder, toFn, fromFn, null);
    }

    public static <T, IntermediateT> DelegateCoder<T, IntermediateT> of(Coder<IntermediateT> coder, CodingFunction<T, IntermediateT> toFn, CodingFunction<IntermediateT, T> fromFn, @Nullable TypeDescriptor<T> typeDescriptor) {
        return new DelegateCoder<T, IntermediateT>(coder, toFn, fromFn, typeDescriptor);
    }

    @Override
    public void encode(T value, OutputStream outStream) throws CoderException, IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        this.coder.encode(this.applyAndWrapExceptions(this.toFn, value), outStream, context);
    }

    @Override
    public T decode(InputStream inStream) throws CoderException, IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public T decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        return this.applyAndWrapExceptions(this.fromFn, this.coder.decode(inStream, context));
    }

    public Coder<IntermediateT> getCoder() {
        return this.coder;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.coder.verifyDeterministic();
    }

    @Override
    public Object structuralValue(T value) {
        try {
            IntermediateT intermediate = this.toFn.apply(value);
            return this.coder.structuralValue(intermediate);
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegateCoder that = (DelegateCoder)o;
        return Objects.equal(this.coder, that.coder) && Objects.equal(this.toFn, that.toFn) && Objects.equal(this.fromFn, that.fromFn);
    }

    public int hashCode() {
        return Objects.hashCode(this.coder, this.toFn, this.fromFn);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("coder", this.coder).add("toFn", this.toFn).add("fromFn", this.fromFn).toString();
    }

    @Override
    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        if (this.typeDescriptor == null) {
            return super.getEncodedTypeDescriptor();
        }
        return this.typeDescriptor;
    }

    private String delegateEncodingId(Class<?> delegateClass, String encodingId) {
        return String.format("%s:%s", delegateClass.getName(), encodingId);
    }

    private <InputT, OutputT> OutputT applyAndWrapExceptions(CodingFunction<InputT, OutputT> fn, InputT input) throws CoderException, IOException {
        try {
            return fn.apply(input);
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new CoderException(exc);
        }
    }

    protected DelegateCoder(Coder<IntermediateT> coder, CodingFunction<T, IntermediateT> toFn, CodingFunction<IntermediateT, T> fromFn, @Nullable TypeDescriptor<T> typeDescriptor) {
        this.coder = coder;
        this.fromFn = fromFn;
        this.toFn = toFn;
        this.typeDescriptor = typeDescriptor;
    }

    public static interface CodingFunction<InputT, OutputT>
    extends Serializable {
        public OutputT apply(InputT var1) throws Exception;
    }
}

