/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.xerial.snappy.Snappy;

public class SnappyCoder<T>
extends StructuredCoder<T> {
    private final Coder<T> innerCoder;

    public static <T> SnappyCoder<T> of(Coder<T> innerCoder) {
        return new SnappyCoder<T>(innerCoder);
    }

    private SnappyCoder(Coder<T> innerCoder) {
        this.innerCoder = innerCoder;
    }

    @Override
    public void encode(T value, OutputStream os) throws IOException {
        ByteArrayCoder.of().encode(Snappy.compress(CoderUtils.encodeToByteArray(this.innerCoder, value)), os);
    }

    @Override
    public T decode(InputStream is) throws IOException {
        return CoderUtils.decodeFromByteArray(this.innerCoder, Snappy.uncompress(ByteArrayCoder.of().decode(is)));
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.innerCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.innerCoder.verifyDeterministic();
    }
}

