/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;

public class VarIntCoder
extends AtomicCoder<Integer> {
    private static final VarIntCoder INSTANCE = new VarIntCoder();
    private static final TypeDescriptor<Integer> TYPE_DESCRIPTOR = new TypeDescriptor<Integer>(){};

    public static VarIntCoder of() {
        return INSTANCE;
    }

    private VarIntCoder() {
    }

    @Override
    public void encode(Integer value, OutputStream outStream) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        VarInt.encode(value, outStream);
    }

    @Override
    public Integer decode(InputStream inStream) throws IOException, CoderException {
        try {
            return VarInt.decodeInt(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Integer value) {
        return true;
    }

    @Override
    public TypeDescriptor<Integer> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Integer value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        return VarInt.getLength(value.longValue());
    }
}

