/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.storage.GcsPathValidator;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v20_0.com.google.common.util.concurrent.ThreadFactoryBuilder;

public interface GcsOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions {
    @JsonIgnore
    @Description(value="The GcsUtil instance that should be used to communicate with Google Cloud Storage.")
    @Default.InstanceFactory(value=GcsUtil.GcsUtilFactory.class)
    @Hidden
    public GcsUtil getGcsUtil();

    public void setGcsUtil(GcsUtil var1);

    @JsonIgnore
    @Description(value="The ExecutorService instance to use to create multiple threads. Can be overridden to specify an ExecutorService that is compatible with the user's environment. If unset, the default is to create an ExecutorService with an unbounded number of threads; this is compatible with Google AppEngine.")
    @Default.InstanceFactory(value=ExecutorServiceFactory.class)
    @Hidden
    public ExecutorService getExecutorService();

    public void setExecutorService(ExecutorService var1);

    @JsonIgnore
    @Hidden
    @Description(value="The URL for the GCS API.")
    public String getGcsEndpoint();

    public void setGcsEndpoint(String var1);

    @Description(value="The buffer size (in bytes) to use when uploading files to GCS. Please see the documentation for AbstractGoogleAsyncWriteChannel.setUploadBufferSize for more information on the restrictions and performance implications of this value.\n\nhttps://github.com/GoogleCloudPlatform/bigdata-interop/blob/master/util/src/main/java/com/google/cloud/hadoop/util/AbstractGoogleAsyncWriteChannel.java")
    @Nullable
    public Integer getGcsUploadBufferSizeBytes();

    public void setGcsUploadBufferSizeBytes(@Nullable Integer var1);

    @Description(value="The class of the validator that should be created and used to validate paths. If pathValidator has not been set explicitly, an instance of this class will be constructed and used as the path validator.")
    @Default.Class(value=GcsPathValidator.class)
    public Class<? extends PathValidator> getPathValidatorClass();

    public void setPathValidatorClass(Class<? extends PathValidator> var1);

    @JsonIgnore
    @Description(value="The path validator instance that should be used to validate paths. If no path validator has been set explicitly, the default is to use the instance factory that constructs a path validator based upon the currently set pathValidatorClass.")
    @Default.InstanceFactory(value=PathValidatorFactory.class)
    public PathValidator getPathValidator();

    public void setPathValidator(PathValidator var1);

    @Description(value="Experimental. Whether to report performance metrics of certain GCS operations.")
    @Default.Boolean(value=false)
    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public Boolean getGcsPerformanceMetrics();

    public void setGcsPerformanceMetrics(Boolean var1);

    public static class PathValidatorFactory
    implements DefaultValueFactory<PathValidator> {
        @Override
        public PathValidator create(PipelineOptions options) {
            GcsOptions gcsOptions = options.as(GcsOptions.class);
            return InstanceBuilder.ofType(PathValidator.class).fromClass(gcsOptions.getPathValidatorClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
        }
    }

    public static class ExecutorServiceFactory
    implements DefaultValueFactory<ExecutorService> {
        @Override
        public ExecutorService create(PipelineOptions options) {
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
            threadFactoryBuilder.setThreadFactory(MoreExecutors.platformThreadFactory());
            threadFactoryBuilder.setDaemon(true);
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>(), threadFactoryBuilder.build());
        }
    }
}

