/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import com.google.auto.value.AutoValue;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.fn.data.AutoValue_RemoteGrpcPortWrite;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

@AutoValue
public abstract class RemoteGrpcPortWrite {
    public static final String URN = "beam:sink:runner:0.1";
    private static final String LOCAL_INPUT_ID = "local_input";

    public static RemoteGrpcPortWrite writeToPort(String inputPCollectionId, BeamFnApi.RemoteGrpcPort port) {
        return new AutoValue_RemoteGrpcPortWrite(inputPCollectionId, port);
    }

    public static RemoteGrpcPortWrite fromPTransform(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(URN.equals(pTransform.getSpec().getUrn()), "Expected URN for %s, got %s", (Object)RemoteGrpcPortWrite.class.getSimpleName(), (Object)pTransform.getSpec().getUrn());
        Preconditions.checkArgument(pTransform.getInputsCount() == 1, "Expected exactly one output, got %s", pTransform.getOutputsCount());
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.parseFrom(pTransform.getSpec().getPayload());
        String inputPCollectionId = Iterables.getOnlyElement(pTransform.getInputsMap().values());
        return RemoteGrpcPortWrite.writeToPort(inputPCollectionId, port);
    }

    abstract String getInputPCollectionId();

    public abstract BeamFnApi.RemoteGrpcPort getPort();

    public RunnerApi.PTransform toPTransform() {
        return RunnerApi.PTransform.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(URN).setPayload(this.getPort().toByteString()).build()).putInputs(LOCAL_INPUT_ID, this.getInputPCollectionId()).build();
    }
}

