/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.splittabledofn.Backlog;
import org.apache.beam.sdk.transforms.splittabledofn.Backlogs;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;

public class RestrictionTrackers {
    public static <RestrictionT, PositionT> RestrictionTracker<RestrictionT, PositionT> observe(RestrictionTracker<RestrictionT, PositionT> restrictionTracker, ClaimObserver<PositionT> claimObserver) {
        if (restrictionTracker instanceof Backlogs.HasPartitionedBacklog) {
            return new RestrictionTrackerObserverWithPartitionedBacklog<RestrictionT, PositionT>(restrictionTracker, claimObserver);
        }
        if (restrictionTracker instanceof Backlogs.HasBacklog) {
            return new RestrictionTrackerObserverWithBacklog<RestrictionT, PositionT>(restrictionTracker, claimObserver);
        }
        return new RestrictionTrackerObserver<RestrictionT, PositionT>(restrictionTracker, claimObserver);
    }

    @ThreadSafe
    private static class RestrictionTrackerObserverWithPartitionedBacklog<RestrictionT, PositionT>
    extends RestrictionTrackerObserverWithBacklog<RestrictionT, PositionT>
    implements Backlogs.HasPartitionedBacklog {
        protected RestrictionTrackerObserverWithPartitionedBacklog(RestrictionTracker<RestrictionT, PositionT> delegate, ClaimObserver<PositionT> claimObserver) {
            super(delegate, claimObserver);
        }

        @Override
        public synchronized byte[] getBacklogPartition() {
            return ((Backlogs.HasPartitionedBacklog)((Object)this.delegate)).getBacklogPartition();
        }
    }

    @ThreadSafe
    private static class RestrictionTrackerObserverWithBacklog<RestrictionT, PositionT>
    extends RestrictionTrackerObserver<RestrictionT, PositionT>
    implements Backlogs.HasBacklog {
        protected RestrictionTrackerObserverWithBacklog(RestrictionTracker<RestrictionT, PositionT> delegate, ClaimObserver<PositionT> claimObserver) {
            super(delegate, claimObserver);
        }

        @Override
        public synchronized Backlog getBacklog() {
            return ((Backlogs.HasBacklog)((Object)this.delegate)).getBacklog();
        }
    }

    @ThreadSafe
    private static class RestrictionTrackerObserver<RestrictionT, PositionT>
    extends RestrictionTracker<RestrictionT, PositionT> {
        protected final RestrictionTracker<RestrictionT, PositionT> delegate;
        private final ClaimObserver<PositionT> claimObserver;

        protected RestrictionTrackerObserver(RestrictionTracker<RestrictionT, PositionT> delegate, ClaimObserver<PositionT> claimObserver) {
            this.delegate = delegate;
            this.claimObserver = claimObserver;
        }

        @Override
        public synchronized boolean tryClaim(PositionT position) {
            if (this.delegate.tryClaim(position)) {
                this.claimObserver.onClaimed(position);
                return true;
            }
            this.claimObserver.onClaimFailed(position);
            return false;
        }

        @Override
        public synchronized RestrictionT currentRestriction() {
            return this.delegate.currentRestriction();
        }

        @Override
        public synchronized RestrictionT checkpoint() {
            return this.delegate.checkpoint();
        }

        @Override
        public synchronized void checkDone() throws IllegalStateException {
            this.delegate.checkDone();
        }
    }

    public static interface ClaimObserver<PositionT> {
        public void onClaimed(PositionT var1);

        public void onClaimFailed(PositionT var1);
    }
}

