/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.ValueProvider;

final class AutoValue_TextIO_Read
extends TextIO.Read {
    private final ValueProvider<String> filepattern;
    private final FileIO.MatchConfiguration matchConfiguration;
    private final boolean hintMatchesManyFiles;
    private final Compression compression;
    private final byte[] delimiter;

    private AutoValue_TextIO_Read(@Nullable ValueProvider<String> filepattern, FileIO.MatchConfiguration matchConfiguration, boolean hintMatchesManyFiles, Compression compression, @Nullable byte[] delimiter) {
        this.filepattern = filepattern;
        this.matchConfiguration = matchConfiguration;
        this.hintMatchesManyFiles = hintMatchesManyFiles;
        this.compression = compression;
        this.delimiter = delimiter;
    }

    @Override
    @Nullable
    ValueProvider<String> getFilepattern() {
        return this.filepattern;
    }

    @Override
    FileIO.MatchConfiguration getMatchConfiguration() {
        return this.matchConfiguration;
    }

    @Override
    boolean getHintMatchesManyFiles() {
        return this.hintMatchesManyFiles;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    @Override
    @Nullable
    byte[] getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TextIO.Read) {
            TextIO.Read that = (TextIO.Read)o;
            return (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && this.matchConfiguration.equals(that.getMatchConfiguration()) && this.hintMatchesManyFiles == that.getHintMatchesManyFiles() && this.compression.equals((Object)that.getCompression()) && Arrays.equals(this.delimiter, that instanceof AutoValue_TextIO_Read ? ((AutoValue_TextIO_Read)that).delimiter : that.getDelimiter());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.matchConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.hintMatchesManyFiles ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.compression.hashCode();
        h$ *= 1000003;
        return h$ ^= Arrays.hashCode(this.delimiter);
    }

    @Override
    TextIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TextIO.Read.Builder {
        private ValueProvider<String> filepattern;
        private FileIO.MatchConfiguration matchConfiguration;
        private Boolean hintMatchesManyFiles;
        private Compression compression;
        private byte[] delimiter;

        Builder() {
        }

        private Builder(TextIO.Read source) {
            this.filepattern = source.getFilepattern();
            this.matchConfiguration = source.getMatchConfiguration();
            this.hintMatchesManyFiles = source.getHintMatchesManyFiles();
            this.compression = source.getCompression();
            this.delimiter = source.getDelimiter();
        }

        @Override
        TextIO.Read.Builder setFilepattern(ValueProvider<String> filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        TextIO.Read.Builder setMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            if (matchConfiguration == null) {
                throw new NullPointerException("Null matchConfiguration");
            }
            this.matchConfiguration = matchConfiguration;
            return this;
        }

        @Override
        TextIO.Read.Builder setHintMatchesManyFiles(boolean hintMatchesManyFiles) {
            this.hintMatchesManyFiles = hintMatchesManyFiles;
            return this;
        }

        @Override
        TextIO.Read.Builder setCompression(Compression compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        TextIO.Read.Builder setDelimiter(byte[] delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        TextIO.Read build() {
            String missing = "";
            if (this.matchConfiguration == null) {
                missing = missing + " matchConfiguration";
            }
            if (this.hintMatchesManyFiles == null) {
                missing = missing + " hintMatchesManyFiles";
            }
            if (this.compression == null) {
                missing = missing + " compression";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TextIO_Read(this.filepattern, this.matchConfiguration, this.hintMatchesManyFiles, this.compression, this.delimiter);
        }
    }
}

