/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public abstract class BlockBasedSource<T>
extends FileBasedSource<T> {
    public BlockBasedSource(String fileOrPatternSpec, EmptyMatchTreatment emptyMatchTreatment, long minBundleSize) {
        this(ValueProvider.StaticValueProvider.of(fileOrPatternSpec), emptyMatchTreatment, minBundleSize);
    }

    public BlockBasedSource(String fileOrPatternSpec, long minBundleSize) {
        this(ValueProvider.StaticValueProvider.of(fileOrPatternSpec), minBundleSize);
    }

    public BlockBasedSource(ValueProvider<String> fileOrPatternSpec, long minBundleSize) {
        this(fileOrPatternSpec, EmptyMatchTreatment.DISALLOW, minBundleSize);
    }

    public BlockBasedSource(ValueProvider<String> fileOrPatternSpec, EmptyMatchTreatment emptyMatchTreatment, long minBundleSize) {
        super(fileOrPatternSpec, emptyMatchTreatment, minBundleSize);
    }

    public BlockBasedSource(MatchResult.Metadata metadata, long minBundleSize, long startOffset, long endOffset) {
        super(metadata, minBundleSize, startOffset, endOffset);
    }

    @Override
    protected abstract BlockBasedSource<T> createForSubrangeOfFile(MatchResult.Metadata var1, long var2, long var4);

    @Override
    protected abstract BlockBasedReader<T> createSingleFileReader(PipelineOptions var1);

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class BlockBasedReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private boolean atSplitPoint;

        protected BlockBasedReader(BlockBasedSource<T> source) {
            super(source);
        }

        public abstract boolean readNextBlock() throws IOException;

        @Nullable
        public abstract Block<T> getCurrentBlock();

        public abstract long getCurrentBlockSize();

        public abstract long getCurrentBlockOffset();

        @Override
        public final T getCurrent() throws NoSuchElementException {
            Block<T> currentBlock = this.getCurrentBlock();
            if (currentBlock == null) {
                throw new NoSuchElementException("No block has been successfully read from " + this.getCurrentSource());
            }
            return currentBlock.getCurrentRecord();
        }

        @Override
        protected boolean isAtSplitPoint() {
            return this.atSplitPoint;
        }

        @Override
        protected final boolean readNextRecord() throws IOException {
            this.atSplitPoint = false;
            while (this.getCurrentBlock() == null || !this.getCurrentBlock().readNextRecord()) {
                if (!this.readNextBlock()) {
                    return false;
                }
                this.atSplitPoint = true;
            }
            return true;
        }

        @Override
        @Nullable
        public Double getFractionConsumed() {
            if (!this.isStarted()) {
                return 0.0;
            }
            if (this.isDone()) {
                return 1.0;
            }
            OffsetBasedSource source = this.getCurrentSource();
            if (source.getEndOffset() == Long.MAX_VALUE) {
                return null;
            }
            long currentBlockOffset = this.getCurrentBlockOffset();
            long startOffset = source.getStartOffset();
            long endOffset = source.getEndOffset();
            double fractionAtBlockStart = (double)(currentBlockOffset - startOffset) / (double)(endOffset - startOffset);
            double fractionAtBlockEnd = (double)(currentBlockOffset + this.getCurrentBlockSize() - startOffset) / (double)(endOffset - startOffset);
            double blockFraction = this.getCurrentBlock().getFractionOfBlockConsumed();
            return Math.min(1.0, fractionAtBlockStart + blockFraction * (fractionAtBlockEnd - fractionAtBlockStart));
        }

        @Override
        protected long getCurrentOffset() {
            return this.getCurrentBlockOffset();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class Block<T> {
        protected Block() {
        }

        public abstract T getCurrentRecord();

        public abstract boolean readNextRecord() throws IOException;

        public abstract double getFractionOfBlockConsumed();
    }
}

