/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class DynamicFileDestinations {
    public static <UserT, OutputT> FileBasedSink.DynamicDestinations<UserT, Void, OutputT> constant(FileBasedSink.FilenamePolicy filenamePolicy, SerializableFunction<UserT, OutputT> formatFunction) {
        return new ConstantFilenamePolicy<UserT, OutputT>(filenamePolicy, formatFunction);
    }

    public static <UserT> FileBasedSink.DynamicDestinations<UserT, Void, UserT> constant(FileBasedSink.FilenamePolicy filenamePolicy) {
        return new ConstantFilenamePolicy(filenamePolicy, SerializableFunctions.identity());
    }

    public static <UserT, OutputT> FileBasedSink.DynamicDestinations<UserT, DefaultFilenamePolicy.Params, OutputT> toDefaultPolicies(SerializableFunction<UserT, DefaultFilenamePolicy.Params> destinationFunction, DefaultFilenamePolicy.Params emptyDestination, SerializableFunction<UserT, OutputT> formatFunction) {
        return new DefaultPolicyDestinations<UserT, OutputT>(destinationFunction, emptyDestination, formatFunction);
    }

    private static class DefaultPolicyDestinations<UserT, OutputT>
    extends FileBasedSink.DynamicDestinations<UserT, DefaultFilenamePolicy.Params, OutputT> {
        private final SerializableFunction<UserT, DefaultFilenamePolicy.Params> destinationFunction;
        private final DefaultFilenamePolicy.Params emptyDestination;
        private final SerializableFunction<UserT, OutputT> formatFunction;

        public DefaultPolicyDestinations(SerializableFunction<UserT, DefaultFilenamePolicy.Params> destinationFunction, DefaultFilenamePolicy.Params emptyDestination, SerializableFunction<UserT, OutputT> formatFunction) {
            this.destinationFunction = destinationFunction;
            this.emptyDestination = emptyDestination;
            this.formatFunction = formatFunction;
        }

        @Override
        public OutputT formatRecord(UserT record) {
            return this.formatFunction.apply(record);
        }

        @Override
        public DefaultFilenamePolicy.Params getDestination(UserT element) {
            return this.destinationFunction.apply(element);
        }

        @Override
        public DefaultFilenamePolicy.Params getDefaultDestination() {
            return this.emptyDestination;
        }

        @Override
        @Nullable
        public Coder<DefaultFilenamePolicy.Params> getDestinationCoder() {
            return DefaultFilenamePolicy.ParamsCoder.of();
        }

        @Override
        public FileBasedSink.FilenamePolicy getFilenamePolicy(DefaultFilenamePolicy.Params params) {
            return DefaultFilenamePolicy.fromParams(params);
        }
    }

    private static class ConstantFilenamePolicy<UserT, OutputT>
    extends FileBasedSink.DynamicDestinations<UserT, Void, OutputT> {
        private final FileBasedSink.FilenamePolicy filenamePolicy;
        private final SerializableFunction<UserT, OutputT> formatFunction;

        public ConstantFilenamePolicy(FileBasedSink.FilenamePolicy filenamePolicy, SerializableFunction<UserT, OutputT> formatFunction) {
            this.filenamePolicy = filenamePolicy;
            this.formatFunction = formatFunction;
        }

        @Override
        public OutputT formatRecord(UserT record) {
            return this.formatFunction.apply(record);
        }

        @Override
        @Nullable
        public Void getDestination(UserT element) {
            return null;
        }

        @Override
        @Nullable
        public Coder<Void> getDestinationCoder() {
            return null;
        }

        @Override
        @Nullable
        public Void getDefaultDestination() {
            return null;
        }

        @Override
        public FileBasedSink.FilenamePolicy getFilenamePolicy(Void destination) {
            return this.filenamePolicy;
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            Preconditions.checkState(this.filenamePolicy != null);
            this.filenamePolicy.populateDisplayData(builder);
        }
    }
}

