/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SystemUtils;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

class LocalResourceId
implements ResourceId {
    private final String pathString;
    @Nullable
    private volatile transient Path cachedPath;
    private final boolean isDirectory;

    static LocalResourceId fromPath(Path path, boolean isDirectory) {
        Preconditions.checkNotNull(path, "path");
        return new LocalResourceId(path, isDirectory);
    }

    private LocalResourceId(Path path, boolean isDirectory) {
        this.pathString = path.toAbsolutePath().normalize().toString() + (isDirectory ? Character.valueOf(File.separatorChar) : "");
        this.isDirectory = isDirectory;
    }

    @Override
    public LocalResourceId resolve(String other, ResolveOptions resolveOptions) {
        Preconditions.checkState(this.isDirectory, "Expected the path is a directory, but had [%s].", (Object)this.pathString);
        Preconditions.checkArgument(resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE) || resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY), "ResolveOptions: [%s] is not supported.", (Object)resolveOptions);
        Preconditions.checkArgument(!resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE) || !other.endsWith("/"), "The resolved file: [%s] should not end with '/'.", (Object)other);
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.resolveLocalPathWindowsOS(other, resolveOptions);
        }
        return this.resolveLocalPath(other, resolveOptions);
    }

    @Override
    public LocalResourceId getCurrentDirectory() {
        if (this.isDirectory) {
            return this;
        }
        Path path = this.getPath();
        Path parent = path.getParent();
        if (parent == null && path.getNameCount() == 1) {
            parent = Paths.get(".", new String[0]);
        }
        Preconditions.checkState(parent != null, "Failed to get the current directory for path: [%s].", (Object)this.pathString);
        return LocalResourceId.fromPath(parent, true);
    }

    @Override
    @Nullable
    public String getFilename() {
        Path fileName = this.getPath().getFileName();
        return fileName == null ? null : fileName.toString();
    }

    private LocalResourceId resolveLocalPath(String other, ResolveOptions resolveOptions) {
        return new LocalResourceId(this.getPath().resolve(other), resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
    }

    private LocalResourceId resolveLocalPathWindowsOS(String other, ResolveOptions resolveOptions) {
        String uuid = UUID.randomUUID().toString();
        Path pathAsterisksReplaced = Paths.get(this.pathString.replaceAll("\\*", uuid), new String[0]);
        String otherAsterisksReplaced = other.replaceAll("\\*", uuid);
        return new LocalResourceId(Paths.get(pathAsterisksReplaced.resolve(otherAsterisksReplaced).toString().replaceAll(uuid, "\\*"), new String[0]), resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    Path getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = Paths.get(this.pathString, new String[0]);
        }
        return this.cachedPath;
    }

    @Override
    public String toString() {
        return this.pathString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalResourceId)) {
            return false;
        }
        LocalResourceId other = (LocalResourceId)obj;
        return this.pathString.equals(other.pathString) && this.isDirectory == other.isDirectory;
    }

    public int hashCode() {
        return Objects.hash(this.pathString, this.isDirectory);
    }
}

