/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;

class TextSink<UserT, DestinationT>
extends FileBasedSink<UserT, DestinationT, String> {
    @Nullable
    private final String header;
    @Nullable
    private final String footer;
    private final char[] delimiter;

    TextSink(ValueProvider<ResourceId> baseOutputFilename, FileBasedSink.DynamicDestinations<UserT, DestinationT, String> dynamicDestinations, char[] delimiter, @Nullable String header, @Nullable String footer, FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
        super(baseOutputFilename, dynamicDestinations, writableByteChannelFactory);
        this.header = header;
        this.footer = footer;
        this.delimiter = delimiter;
    }

    @Override
    public FileBasedSink.WriteOperation<DestinationT, String> createWriteOperation() {
        return new TextWriteOperation(this, this.delimiter, this.header, this.footer);
    }

    private static class TextWriter<DestinationT>
    extends FileBasedSink.Writer<DestinationT, String> {
        private static final String NEWLINE = "\n";
        @Nullable
        private final String header;
        @Nullable
        private final String footer;
        private final char[] delimiter;
        @Nullable
        private OutputStreamWriter out;

        public TextWriter(FileBasedSink.WriteOperation<DestinationT, String> writeOperation, char[] delimiter, @Nullable String header, @Nullable String footer) {
            super(writeOperation, "text/plain");
            this.delimiter = delimiter;
            this.header = header;
            this.footer = footer;
        }

        private void writeIfNotNull(@Nullable String value) throws IOException {
            if (value != null) {
                this.writeLine(value);
            }
        }

        private void writeLine(String value) throws IOException {
            this.out.write(value);
            this.out.write(this.delimiter);
        }

        @Override
        protected void prepareWrite(WritableByteChannel channel) throws Exception {
            this.out = new OutputStreamWriter(Channels.newOutputStream(channel), StandardCharsets.UTF_8);
        }

        @Override
        protected void writeHeader() throws Exception {
            this.writeIfNotNull(this.header);
        }

        @Override
        public void write(String value) throws Exception {
            this.writeLine(value);
        }

        @Override
        protected void writeFooter() throws Exception {
            this.writeIfNotNull(this.footer);
        }

        @Override
        protected void finishWrite() throws Exception {
            this.out.flush();
        }
    }

    private static class TextWriteOperation<DestinationT>
    extends FileBasedSink.WriteOperation<DestinationT, String> {
        @Nullable
        private final String header;
        @Nullable
        private final String footer;
        private final char[] delimiter;

        private TextWriteOperation(TextSink sink, char[] delimiter, @Nullable String header, @Nullable String footer) {
            super(sink);
            this.header = header;
            this.footer = footer;
            this.delimiter = delimiter;
        }

        @Override
        public FileBasedSink.Writer<DestinationT, String> createWriter() throws Exception {
            return new TextWriter(this, this.delimiter, this.header, this.footer);
        }
    }
}

