/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.core.com.google.protobuf.ByteString;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@VisibleForTesting
class TextSource
extends FileBasedSource<String> {
    byte[] delimiter;

    TextSource(ValueProvider<String> fileSpec, EmptyMatchTreatment emptyMatchTreatment, byte[] delimiter) {
        super(fileSpec, emptyMatchTreatment, 1L);
        this.delimiter = delimiter;
    }

    private TextSource(MatchResult.Metadata metadata, long start, long end, byte[] delimiter) {
        super(metadata, 1L, start, end);
        this.delimiter = delimiter;
    }

    @Override
    protected FileBasedSource<String> createForSubrangeOfFile(MatchResult.Metadata metadata, long start, long end) {
        return new TextSource(metadata, start, end, this.delimiter);
    }

    @Override
    protected FileBasedSource.FileBasedReader<String> createSingleFileReader(PipelineOptions options) {
        return new TextBasedReader(this, this.delimiter);
    }

    @Override
    public Coder<String> getOutputCoder() {
        return StringUtf8Coder.of();
    }

    @VisibleForTesting
    static class TextBasedReader
    extends FileBasedSource.FileBasedReader<String> {
        private static final int READ_BUFFER_SIZE = 8192;
        private final ByteBuffer readBuffer = ByteBuffer.allocate(8192);
        private ByteString buffer = ByteString.EMPTY;
        private int startOfDelimiterInBuffer;
        private int endOfDelimiterInBuffer;
        private long startOfRecord;
        private volatile long startOfNextRecord;
        private volatile boolean eof;
        private volatile boolean elementIsPresent;
        @Nullable
        private String currentValue;
        @Nullable
        private ReadableByteChannel inChannel;
        @Nullable
        private byte[] delimiter;

        private TextBasedReader(TextSource source, byte[] delimiter) {
            super(source);
            this.delimiter = delimiter;
        }

        @Override
        protected long getCurrentOffset() throws NoSuchElementException {
            if (!this.elementIsPresent) {
                throw new NoSuchElementException();
            }
            return this.startOfRecord;
        }

        @Override
        public long getSplitPointsRemaining() {
            if (this.isStarted() && this.startOfNextRecord >= this.getCurrentSource().getEndOffset()) {
                return this.isDone() ? 0L : 1L;
            }
            return super.getSplitPointsRemaining();
        }

        @Override
        public String getCurrent() throws NoSuchElementException {
            if (!this.elementIsPresent) {
                throw new NoSuchElementException();
            }
            return this.currentValue;
        }

        @Override
        protected void startReading(ReadableByteChannel channel) throws IOException {
            this.inChannel = channel;
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset > 0L) {
                Preconditions.checkState(channel instanceof SeekableByteChannel, "%s only supports reading from a SeekableByteChannel when given a start offset greater than 0.", (Object)TextSource.class.getSimpleName());
                long requiredPosition = startOffset - 1L;
                if (this.delimiter != null && startOffset >= (long)this.delimiter.length) {
                    requiredPosition = startOffset - (long)this.delimiter.length;
                }
                ((SeekableByteChannel)channel).position(requiredPosition);
                this.findDelimiterBounds();
                this.buffer = this.buffer.substring(this.endOfDelimiterInBuffer);
                this.startOfNextRecord = requiredPosition + (long)this.endOfDelimiterInBuffer;
                this.endOfDelimiterInBuffer = 0;
                this.startOfDelimiterInBuffer = 0;
            }
        }

        private void findDelimiterBounds() throws IOException {
            int bytePositionInBuffer = 0;
            while (true) {
                if (!this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 1)) {
                    this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                    break;
                }
                byte currentByte = this.buffer.byteAt(bytePositionInBuffer);
                if (this.delimiter == null) {
                    if (currentByte == 10) {
                        this.startOfDelimiterInBuffer = bytePositionInBuffer;
                        this.endOfDelimiterInBuffer = this.startOfDelimiterInBuffer + 1;
                        break;
                    }
                    if (currentByte == 13) {
                        this.startOfDelimiterInBuffer = bytePositionInBuffer;
                        this.endOfDelimiterInBuffer = this.startOfDelimiterInBuffer + 1;
                        if (!this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 2) || (currentByte = this.buffer.byteAt(bytePositionInBuffer + 1)) != 10) break;
                        ++this.endOfDelimiterInBuffer;
                        break;
                    }
                } else {
                    int i = 0;
                    this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                    while (i <= this.delimiter.length - 1 && currentByte == this.delimiter[i]) {
                        if (this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + ++i + 1)) {
                            currentByte = this.buffer.byteAt(bytePositionInBuffer + i);
                            continue;
                        }
                        this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                        break;
                    }
                    if (i == this.delimiter.length) {
                        this.endOfDelimiterInBuffer = bytePositionInBuffer + i;
                        break;
                    }
                }
                ++bytePositionInBuffer;
            }
        }

        @Override
        protected boolean readNextRecord() throws IOException {
            this.startOfRecord = this.startOfNextRecord;
            this.findDelimiterBounds();
            if (this.eof && this.buffer.isEmpty()) {
                this.elementIsPresent = false;
                return false;
            }
            this.decodeCurrentElement();
            this.startOfNextRecord = this.startOfRecord + (long)this.endOfDelimiterInBuffer;
            return true;
        }

        private void decodeCurrentElement() throws IOException {
            ByteString dataToDecode = this.buffer.substring(0, this.startOfDelimiterInBuffer);
            this.currentValue = dataToDecode.toStringUtf8();
            this.elementIsPresent = true;
            this.buffer = this.buffer.substring(this.endOfDelimiterInBuffer);
        }

        private boolean tryToEnsureNumberOfBytesInBuffer(int minCapacity) throws IOException {
            while (this.buffer.size() <= minCapacity && !this.eof) {
                this.eof = this.inChannel.read(this.readBuffer) == -1;
                this.readBuffer.flip();
                this.buffer = this.buffer.concat(ByteString.copyFrom(this.readBuffer));
                this.readBuffer.clear();
            }
            return this.buffer.size() >= minCapacity;
        }
    }
}

