/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.fs.AutoValue_MatchResult_Failure;
import org.apache.beam.sdk.io.fs.AutoValue_MatchResult_Metadata;
import org.apache.beam.sdk.io.fs.AutoValue_MatchResult_Success;
import org.apache.beam.sdk.io.fs.ResourceId;

public abstract class MatchResult {
    private MatchResult() {
    }

    public static MatchResult create(Status status, List<Metadata> metadata) {
        return new AutoValue_MatchResult_Success(status, metadata);
    }

    public static MatchResult create(Status status, IOException e) {
        return new AutoValue_MatchResult_Failure(status, e);
    }

    public static MatchResult unknown() {
        return new AutoValue_MatchResult_Failure(Status.UNKNOWN, new IOException("MatchResult status is UNKNOWN, and metadata is not available."));
    }

    public abstract Status status();

    public abstract List<Metadata> metadata() throws IOException;

    public static enum Status {
        UNKNOWN,
        OK,
        NOT_FOUND,
        ERROR;

    }

    @AutoValue
    public static abstract class Metadata
    implements Serializable {
        private static final long UNKNOWN_LAST_MODIFIED_MILLIS = 0L;

        public abstract ResourceId resourceId();

        public abstract long sizeBytes();

        public abstract boolean isReadSeekEfficient();

        @Experimental
        public abstract long lastModifiedMillis();

        public static Builder builder() {
            return new AutoValue_MatchResult_Metadata.Builder().setLastModifiedMillis(0L);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setResourceId(ResourceId var1);

            public abstract Builder setSizeBytes(long var1);

            public abstract Builder setIsReadSeekEfficient(boolean var1);

            public abstract Builder setLastModifiedMillis(long var1);

            public abstract Metadata build();
        }
    }

    @AutoValue
    static abstract class Failure
    extends MatchResult {
        Failure() {
        }

        abstract IOException getException();

        @Override
        public List<Metadata> metadata() throws IOException {
            throw this.getException();
        }
    }

    @AutoValue
    static abstract class Success
    extends MatchResult {
        Success() {
        }

        abstract List<Metadata> getMetadata();

        @Override
        public List<Metadata> metadata() throws IOException {
            return this.getMetadata();
        }
    }
}

