/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class OffsetRange
implements Serializable,
HasDefaultTracker<OffsetRange, OffsetRangeTracker> {
    private final long from;
    private final long to;

    public OffsetRange(long from, long to) {
        Preconditions.checkArgument(from <= to, "Malformed range [%s, %s)", from, to);
        this.from = from;
        this.to = to;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    @Override
    public OffsetRangeTracker newTracker() {
        return new OffsetRangeTracker(this);
    }

    public String toString() {
        return "[" + this.from + ", " + this.to + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetRange that = (OffsetRange)o;
        if (this.from != that.from) {
            return false;
        }
        return this.to == that.to;
    }

    public int hashCode() {
        int result = (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        return result;
    }

    public List<OffsetRange> split(long desiredNumOffsetsPerSplit, long minNumOffsetPerSplit) {
        ArrayList<OffsetRange> res = new ArrayList<OffsetRange>();
        long start = this.getFrom();
        long maxEnd = this.getTo();
        while (start < maxEnd) {
            long end = start + desiredNumOffsetsPerSplit;
            long remaining = maxEnd - (end = Math.min(end, maxEnd));
            if (remaining < desiredNumOffsetsPerSplit / 4L || remaining < minNumOffsetPerSplit) {
                end = maxEnd;
            }
            res.add(new OffsetRange(start, end));
            start = end;
        }
        return res;
    }

    public static class Coder
    extends AtomicCoder<OffsetRange> {
        private static final Coder INSTANCE = new Coder();
        private static final TypeDescriptor<OffsetRange> TYPE_DESCRIPTOR = new TypeDescriptor<OffsetRange>(){};

        public static Coder of() {
            return INSTANCE;
        }

        @Override
        public void encode(OffsetRange value, OutputStream outStream) throws CoderException, IOException {
            VarInt.encode(value.from, outStream);
            VarInt.encode(value.to, outStream);
        }

        @Override
        public OffsetRange decode(InputStream inStream) throws CoderException, IOException {
            return new OffsetRange(VarInt.decodeLong(inStream), VarInt.decodeLong(inStream));
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(OffsetRange value) {
            return true;
        }

        @Override
        protected long getEncodedElementByteSize(OffsetRange value) throws Exception {
            return (long)VarInt.getLength(value.from) + (long)VarInt.getLength(value.to);
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }

        @Override
        public TypeDescriptor<OffsetRange> getEncodedTypeDescriptor() {
            return TYPE_DESCRIPTOR;
        }
    }
}

