/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;

public class DelegatingCounter
implements Metric,
Counter,
Serializable {
    private final MetricName name;

    public DelegatingCounter(MetricName name) {
        this.name = name;
    }

    @Override
    public void inc() {
        this.inc(1L);
    }

    @Override
    public void inc(long n) {
        MetricsContainer container = MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getCounter(this.name).inc(n);
        }
    }

    @Override
    public void dec() {
        this.inc(-1L);
    }

    @Override
    public void dec(long n) {
        this.inc(-1L * n);
    }

    @Override
    public MetricName getName() {
        return this.name;
    }
}

