/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.google.auto.value.AutoValue;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;

@JsonFilter(value="committedMetrics")
@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class MetricResult<T> {
    public MetricName getName() {
        return this.getKey().metricName();
    }

    public abstract MetricKey getKey();

    public T getCommitted() {
        T committed = this.getCommittedOrNull();
        if (committed == null) {
            throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
        }
        return committed;
    }

    public boolean hasCommitted() {
        return this.getCommittedOrNull() != null;
    }

    @Nullable
    public abstract T getCommittedOrNull();

    public abstract T getAttempted();

    public <V> MetricResult<V> transform(Function<T, V> fn) {
        T committed = this.getCommittedOrNull();
        return MetricResult.create(this.getKey(), committed == null ? null : (T)fn.apply(committed), fn.apply(this.getAttempted()));
    }

    public MetricResult<T> addAttempted(T update, BiFunction<T, T, T> combine) {
        return MetricResult.create(this.getKey(), this.getCommitted(), combine.apply(this.getAttempted(), update));
    }

    public MetricResult<T> addCommitted(T update, BiFunction<T, T, T> combine) {
        T committed = this.getCommittedOrNull();
        return MetricResult.create(this.getKey(), committed == null ? update : combine.apply(committed, update), this.getAttempted());
    }

    public static <T> MetricResult<T> attempted(MetricKey key, T attempted) {
        return new AutoValue_MetricResult<Object>(key, null, attempted);
    }

    public static <T> MetricResult<T> create(MetricKey key, Boolean isCommittedSupported, T value) {
        if (isCommittedSupported.booleanValue()) {
            return MetricResult.create(key, value, value);
        }
        return MetricResult.attempted(key, value);
    }

    public static <T> MetricResult<T> create(MetricKey key, @Nullable T committed, T attempted) {
        return new AutoValue_MetricResult<T>(key, committed, attempted);
    }
}

