/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.METRICS)
@Internal
public class MetricsEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsEnvironment.class);
    private static final AtomicBoolean METRICS_SUPPORTED = new AtomicBoolean(false);
    private static final AtomicBoolean REPORTED_MISSING_CONTAINER = new AtomicBoolean(false);
    private static final ThreadLocal<MetricsContainer> CONTAINER_FOR_THREAD = new ThreadLocal();

    @Nullable
    public static MetricsContainer setCurrentContainer(@Nullable MetricsContainer container) {
        MetricsContainer previous = CONTAINER_FOR_THREAD.get();
        if (container == null) {
            CONTAINER_FOR_THREAD.remove();
        } else {
            CONTAINER_FOR_THREAD.set(container);
        }
        return previous;
    }

    public static void setMetricsSupported(boolean supported) {
        METRICS_SUPPORTED.set(supported);
    }

    public static boolean isMetricsSupported() {
        return METRICS_SUPPORTED.get();
    }

    public static Closeable scopedMetricsContainer(MetricsContainer container) {
        return new ScopedContainer(container);
    }

    @Nullable
    public static MetricsContainer getCurrentContainer() {
        MetricsContainer container = CONTAINER_FOR_THREAD.get();
        if (container == null && REPORTED_MISSING_CONTAINER.compareAndSet(false, true)) {
            if (METRICS_SUPPORTED.get()) {
                LOG.error("Unable to update metrics on the current thread. Most likely caused by using metrics outside the managed work-execution thread.");
            } else {
                LOG.warn("Reporting metrics are not supported in the current execution environment.");
            }
        }
        return container;
    }

    private static class ScopedContainer
    implements Closeable {
        @Nullable
        private final MetricsContainer oldContainer;

        private ScopedContainer(MetricsContainer newContainer) {
            this.oldContainer = MetricsEnvironment.setCurrentContainer(newContainer);
        }

        @Override
        public void close() throws IOException {
            MetricsEnvironment.setCurrentContainer(this.oldContainer);
        }
    }
}

