/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@Description(value="Options that are used to control configuration of the SDK harness.")
@Experimental
public interface SdkHarnessOptions
extends PipelineOptions {
    @Description(value="Controls the default log level of all loggers without a log level override.")
    @Default.Enum(value="INFO")
    public LogLevel getDefaultSdkHarnessLogLevel();

    public void setDefaultSdkHarnessLogLevel(LogLevel var1);

    @Description(value="This option controls the log levels for specifically named loggers. The expected format is {\"Name\":\"LogLevel\",...}. The SDK harness supports a logging hierarchy based off of names that are '.' separated. For example, by specifying the value {\"a.b.c.Foo\":\"DEBUG\"}, the logger for the class 'a.b.c.Foo' will be configured to output logs at the DEBUG level. Similarly, by specifying the value {\"a.b.c\":\"WARN\"}, all loggers underneath the 'a.b.c' package will be configured to output logs at the WARN level. System.out and System.err levels are configured via loggers of the corresponding name. Also, note that when multiple overrides are specified, the exact name followed by the closest parent takes precedence.")
    public SdkHarnessLogLevelOverrides getSdkHarnessLogLevelOverrides();

    public void setSdkHarnessLogLevelOverrides(SdkHarnessLogLevelOverrides var1);

    public static class SdkHarnessLogLevelOverrides
    extends HashMap<String, LogLevel> {
        public SdkHarnessLogLevelOverrides addOverrideForClass(Class<?> klass, LogLevel logLevel) {
            Preconditions.checkNotNull(klass, "Expected class to be not null.");
            this.addOverrideForName(klass.getName(), logLevel);
            return this;
        }

        public SdkHarnessLogLevelOverrides addOverrideForPackage(Package pkg, LogLevel logLevel) {
            Preconditions.checkNotNull(pkg, "Expected package to be not null.");
            this.addOverrideForName(pkg.getName(), logLevel);
            return this;
        }

        public SdkHarnessLogLevelOverrides addOverrideForName(String name, LogLevel logLevel) {
            Preconditions.checkNotNull(name, "Expected name to be not null.");
            Preconditions.checkNotNull(logLevel, "Expected logLevel to be one of %s.", (Object)Arrays.toString((Object[])LogLevel.values()));
            this.put(name, logLevel);
            return this;
        }

        @JsonCreator
        public static SdkHarnessLogLevelOverrides from(Map<String, String> values) {
            Preconditions.checkNotNull(values, "Expected values to be not null.");
            SdkHarnessLogLevelOverrides overrides = new SdkHarnessLogLevelOverrides();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                try {
                    overrides.addOverrideForName(entry.getKey(), LogLevel.valueOf(entry.getValue()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Unsupported log level '%s' requested for %s. Must be one of %s.", entry.getValue(), entry.getKey(), Arrays.toString((Object[])LogLevel.values())));
                }
            }
            return overrides;
        }
    }

    public static enum LogLevel {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

