/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.runners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TransformHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(TransformHierarchy.class);
    private final Node root;
    private final Map<Node, PInput> unexpandedInputs;
    private final Map<POutput, Node> producers = new HashMap<POutput, Node>();
    private final Map<PValue, PInput> producerInput = new HashMap<PValue, PInput>();
    private Node current;

    public TransformHierarchy() {
        this.unexpandedInputs = new HashMap<Node, PInput>();
        this.current = this.root = new Node();
    }

    public Node pushNode(String name, PInput input, PTransform<?, ?> transform) {
        Preconditions.checkNotNull(transform, "A %s must be provided for all Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(name, "A name must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(input, "An input must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Node node = new Node(this.current, transform, name, input);
        this.unexpandedInputs.put(node, input);
        this.current.addComposite(node);
        this.current = node;
        return this.current;
    }

    @Internal
    public Node pushFinalizedNode(String name, Map<TupleTag<?>, PValue> inputs, PTransform<?, ?> transform, Map<TupleTag<?>, PValue> outputs) {
        Preconditions.checkNotNull(transform, "A %s must be provided for all Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(name, "A name must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(inputs, "An input must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Node node = new Node(this.current, transform, name, inputs, outputs);
        node.finishedSpecifying = true;
        this.current.addComposite(node);
        this.current = node;
        return this.current;
    }

    @Internal
    public Node addFinalizedPrimitiveNode(String name, Map<TupleTag<?>, PValue> inputs, PTransform<?, ?> transform, Map<TupleTag<?>, PValue> outputs) {
        Preconditions.checkNotNull(transform, "A %s must be provided for all Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(name, "A name must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(inputs, "Inputs must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(outputs, "Outputs must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Node node = new Node(this.current, transform, name, inputs, outputs);
        node.finishedSpecifying = true;
        for (PValue output : outputs.values()) {
            this.producers.put(output, node);
        }
        this.current.addComposite(node);
        return node;
    }

    public Node replaceNode(Node existing, PInput input, PTransform<?, ?> transform) {
        Preconditions.checkNotNull(existing);
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(transform);
        Preconditions.checkState(this.unexpandedInputs.isEmpty(), "Replacing a node when the graph has an unexpanded input. This is an SDK bug.");
        Node replacement = new Node(existing.getEnclosingNode(), transform, existing.getFullName(), input);
        for (PValue output : existing.getOutputs().values()) {
            Node producer = this.producers.get(output);
            boolean producedInExisting = false;
            do {
                if (producer.equals(existing)) {
                    producedInExisting = true;
                    continue;
                }
                producer = producer.getEnclosingNode();
            } while (!producedInExisting && !producer.isRootNode());
            if (producedInExisting) {
                this.producers.remove(output);
                LOG.debug("Removed producer for value {} as it is part of a replaced composite {}", (Object)output, (Object)existing.getFullName());
                continue;
            }
            LOG.debug("Value {} not produced in existing node {}", (Object)output, (Object)existing.getFullName());
        }
        existing.getEnclosingNode().replaceChild(existing, replacement);
        this.unexpandedInputs.remove(existing);
        this.unexpandedInputs.put(replacement, input);
        this.current = replacement;
        return replacement;
    }

    public void finishSpecifyingInput() {
        for (PValue inputValue : this.current.getInputs().values()) {
            PInput input = this.producerInput.remove(inputValue);
            Node producerNode = this.maybeGetProducer(inputValue);
            if (producerNode == null) continue;
            inputValue.finishSpecifying(input, producerNode.getTransform());
        }
    }

    public void setOutput(POutput output) {
        for (PCollection<?> value : this.fullyExpand(output).values()) {
            if (!this.producers.containsKey(value)) {
                this.producers.put(value, this.current);
                value.finishSpecifyingOutput(this.current.getFullName(), this.unexpandedInputs.get(this.current), this.current.transform);
            }
            this.producerInput.put(value, this.unexpandedInputs.get(this.current));
        }
        output.finishSpecifyingOutput(this.current.getFullName(), this.unexpandedInputs.get(this.current), this.current.transform);
        this.current.setOutput(output);
    }

    public void replaceOutputs(Map<PValue, PTransformOverrideFactory.ReplacementOutput> originalToReplacement) {
        this.current.replaceOutputs(originalToReplacement);
    }

    public void popNode() {
        this.current.finishSpecifying();
        this.unexpandedInputs.remove(this.current);
        this.current = this.current.getEnclosingNode();
        Preconditions.checkState(this.current != null, "Can't pop the root node of a TransformHierarchy");
    }

    Node maybeGetProducer(PValue produced) {
        return this.producers.get(produced);
    }

    Node getProducer(PValue produced) {
        return Preconditions.checkNotNull(this.maybeGetProducer(produced), "No producer found for %s", (Object)produced);
    }

    public Set<PValue> visit(Pipeline.PipelineVisitor visitor) {
        this.finishSpecifying();
        HashSet<PValue> visitedValues = new HashSet<PValue>();
        this.root.visit(visitor, visitedValues, new HashSet(), new HashSet());
        return visitedValues;
    }

    private void finishSpecifying() {
        for (Map.Entry<PValue, PInput> producerInputEntry : this.producerInput.entrySet()) {
            PValue value = producerInputEntry.getKey();
            value.finishSpecifying(producerInputEntry.getValue(), this.getProducer(value).getTransform());
        }
        this.producerInput.clear();
    }

    public Node getCurrent() {
        return this.current;
    }

    private Map<TupleTag<?>, PCollection<?>> fullyExpand(POutput output) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<TupleTag<?>, PValue> value : output.expand().entrySet()) {
            if (value.getValue() instanceof PCollection) {
                PCollection previous = result.put(value.getKey(), (PCollection)value.getValue());
                Preconditions.checkArgument(previous == null, "Found conflicting %ss in flattened expansion of %s: %s maps to %s and %s", output, TupleTag.class.getSimpleName(), value.getKey(), previous, value.getValue());
                continue;
            }
            if (value.getValue().expand().size() == 1 && Iterables.getOnlyElement(value.getValue().expand().values()).equals(value.getValue())) {
                throw new IllegalStateException(String.format("Non %s %s that expands into itself %s", PCollection.class.getSimpleName(), PValue.class.getSimpleName(), value.getValue()));
            }
            for (Map.Entry<TupleTag<?>, PCollection<?>> valueComponent : this.fullyExpand(value.getValue()).entrySet()) {
                PCollection<?> previous = result.put(valueComponent.getKey(), valueComponent.getValue());
                Preconditions.checkArgument(previous == null, "Found conflicting %ss in flattened expansion of %s: %s maps to %s and %s", output, TupleTag.class.getSimpleName(), valueComponent.getKey(), previous, valueComponent.getValue());
            }
        }
        return result;
    }

    public class Node {
        @Nullable
        private final Node enclosingNode;
        @Nullable
        private final PTransform<?, ?> transform;
        private final String fullName;
        private final List<Node> parts = new ArrayList<Node>();
        private final Map<TupleTag<?>, PValue> inputs;
        @Nullable
        private Map<TupleTag<?>, PValue> outputs;
        @VisibleForTesting
        boolean finishedSpecifying = false;

        private Node() {
            this.enclosingNode = null;
            this.transform = null;
            this.fullName = "";
            this.inputs = Collections.emptyMap();
            this.outputs = Collections.emptyMap();
        }

        private Node(Node enclosingNode, PTransform<?, ?> transform, String fullName, PInput input) {
            this.enclosingNode = enclosingNode;
            this.transform = transform;
            this.fullName = fullName;
            ImmutableMap.Builder<TupleTag<?>, PValue> inputs = ImmutableMap.builder();
            inputs.putAll(input.expand());
            inputs.putAll(transform.getAdditionalInputs());
            this.inputs = inputs.build();
        }

        private Node(@Nullable Node enclosingNode, PTransform<?, ?> transform, @Nullable String fullName, @Nullable Map<TupleTag<?>, PValue> inputs, Map<TupleTag<?>, PValue> outputs) {
            this.enclosingNode = enclosingNode;
            this.transform = transform;
            this.fullName = fullName;
            this.inputs = inputs == null ? Collections.emptyMap() : inputs;
            this.outputs = outputs == null ? Collections.emptyMap() : outputs;
        }

        @Nullable
        public PTransform<?, ?> getTransform() {
            return this.transform;
        }

        public Node getEnclosingNode() {
            return this.enclosingNode;
        }

        public void addComposite(Node node) {
            this.parts.add(node);
        }

        public void replaceChild(Node existing, Node replacement) {
            Preconditions.checkNotNull(existing);
            Preconditions.checkNotNull(replacement);
            int existingIndex = this.parts.indexOf(existing);
            Preconditions.checkArgument(existingIndex >= 0, "Tried to replace a node %s that doesn't exist as a component of node %s", (Object)existing.getFullName(), (Object)this.getFullName());
            LOG.debug("Replaced original node {} with replacement {} at index {}", existing, replacement, existingIndex);
            this.parts.set(existingIndex, replacement);
        }

        public boolean isCompositeNode() {
            return !this.parts.isEmpty() || this.isRootNode() || this.returnsOthersOutput();
        }

        private boolean returnsOthersOutput() {
            PTransform<?, ?> transform = this.getTransform();
            if (this.outputs != null) {
                for (PValue outputValue : this.outputs.values()) {
                    if (TransformHierarchy.this.getProducer(outputValue).getTransform().equals(transform)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isRootNode() {
            return this.transform == null;
        }

        public String getFullName() {
            return this.fullName;
        }

        public Map<TupleTag<?>, PValue> getInputs() {
            return this.inputs;
        }

        private void setOutput(POutput output) {
            Preconditions.checkState(!this.finishedSpecifying);
            Preconditions.checkState(this.outputs == null, "Tried to specify more than one output for %s", (Object)this.getFullName());
            Preconditions.checkNotNull(output, "Tried to set the output of %s to null", (Object)this.getFullName());
            this.outputs = output.expand();
            HashSet<Node> outputProducers = new HashSet<Node>();
            for (PValue outputValue : output.expand().values()) {
                outputProducers.add(TransformHierarchy.this.getProducer(outputValue));
            }
            if (outputProducers.contains(this) && (!this.parts.isEmpty() || outputProducers.size() > 1)) {
                HashSet<String> otherProducerNames = new HashSet<String>();
                for (Node outputProducer : outputProducers) {
                    if (outputProducer == this) continue;
                    otherProducerNames.add(outputProducer.getFullName());
                }
                throw new IllegalArgumentException(String.format("Output of composite transform [%s] contains a primitive %s produced by it. Only primitive transforms are permitted to produce primitive outputs.%n    Outputs: %s%n    Other Producers: %s%n    Components: %s", this.getFullName(), POutput.class.getSimpleName(), output.expand(), otherProducerNames, this.parts));
            }
        }

        void replaceOutputs(Map<PValue, PTransformOverrideFactory.ReplacementOutput> originalToReplacement) {
            Preconditions.checkNotNull(this.outputs, "Outputs haven't been specified for node %s yet", (Object)this.getFullName());
            for (Node node : this.parts) {
                node.replaceOutputs(originalToReplacement);
            }
            ImmutableMap.Builder<TupleTag<?>, PValue> newOutputsBuilder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, PValue> entry : this.outputs.entrySet()) {
                PTransformOverrideFactory.ReplacementOutput mapping = originalToReplacement.get(entry.getValue());
                if (mapping != null) {
                    if (this.equals(TransformHierarchy.this.producers.get(mapping.getReplacement().getValue()))) {
                        TransformHierarchy.this.producerInput.remove(mapping.getReplacement().getValue());
                        TransformHierarchy.this.producers.remove(mapping.getReplacement().getValue());
                        TransformHierarchy.this.producers.put(mapping.getOriginal().getValue(), this);
                    }
                    LOG.debug("Replacing output {} with original {}", (Object)mapping.getReplacement(), (Object)mapping.getOriginal());
                    newOutputsBuilder.put(entry.getKey(), mapping.getOriginal().getValue());
                    continue;
                }
                newOutputsBuilder.put(entry);
            }
            ImmutableMap<TupleTag<?>, PValue> immutableMap = newOutputsBuilder.build();
            Preconditions.checkState(this.outputs.size() == immutableMap.size(), "Number of outputs must be stable across replacement");
            this.outputs = immutableMap;
        }

        public Map<TupleTag<?>, PValue> getOutputs() {
            return this.outputs == null ? Collections.emptyMap() : this.outputs;
        }

        public AppliedPTransform<?, ?, ?> toAppliedPTransform(Pipeline pipeline) {
            return AppliedPTransform.of(this.getFullName(), this.inputs, this.outputs, this.getTransform(), pipeline);
        }

        private void visit(Pipeline.PipelineVisitor visitor, Set<PValue> visitedValues, Set<Node> visitedNodes, Set<Node> skippedComposites) {
            if (this.getEnclosingNode() != null && !visitedNodes.contains(this.getEnclosingNode())) {
                this.getEnclosingNode().visit(visitor, visitedValues, visitedNodes, skippedComposites);
            }
            if (!visitedNodes.add(this)) {
                LOG.debug("Not revisiting previously visited node {}", (Object)this);
                return;
            }
            if (this.childNodeOf(skippedComposites)) {
                LOG.debug("Not revisiting Node {} which is a child of a previously passed composite", (Object)this);
                return;
            }
            if (!this.finishedSpecifying) {
                this.finishSpecifying();
            }
            if (!this.isRootNode()) {
                for (PValue pValue : this.inputs.values()) {
                    Node valueProducer = TransformHierarchy.this.maybeGetProducer(pValue);
                    if (valueProducer == null) continue;
                    if (!visitedNodes.contains(valueProducer)) {
                        valueProducer.visit(visitor, visitedValues, visitedNodes, skippedComposites);
                    }
                    if (!visitedValues.add(pValue)) continue;
                    LOG.debug("Visiting input value {}", (Object)pValue);
                    visitor.visitValue(pValue, valueProducer);
                }
            }
            if (this.isCompositeNode()) {
                LOG.debug("Visiting composite node {}", (Object)this);
                Pipeline.PipelineVisitor.CompositeBehavior recurse = visitor.enterCompositeTransform(this);
                if (recurse.equals((Object)Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM)) {
                    for (Node child : this.parts) {
                        child.visit(visitor, visitedValues, visitedNodes, skippedComposites);
                    }
                } else {
                    skippedComposites.add(this);
                }
                visitor.leaveCompositeTransform(this);
            } else {
                LOG.debug("Visiting primitive node {}", (Object)this);
                visitor.visitPrimitiveTransform(this);
            }
            if (!this.isRootNode()) {
                Preconditions.checkNotNull(this.outputs, "Outputs for non-root node %s are null", (Object)this.getFullName());
                for (PValue pValue : this.outputs.values()) {
                    if (!visitedValues.add(pValue)) continue;
                    LOG.debug("Visiting output value {}", (Object)pValue);
                    visitor.visitValue(pValue, this);
                }
            }
        }

        private boolean childNodeOf(Set<Node> nodes) {
            if (this.isRootNode()) {
                return false;
            }
            Node parent = this.getEnclosingNode();
            while (!parent.isRootNode() && !nodes.contains(parent)) {
                parent = parent.getEnclosingNode();
            }
            return nodes.contains(parent);
        }

        private void finishSpecifying() {
            if (this.finishedSpecifying) {
                return;
            }
            this.finishedSpecifying = true;
        }

        public String toString() {
            if (this.isRootNode()) {
                return "RootNode";
            }
            return MoreObjects.toStringHelper(this.getClass()).add("fullName", this.fullName).toString();
        }
    }
}

