/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;

final class AutoValue_FieldAccessDescriptor
extends FieldAccessDescriptor {
    private final boolean allFields;
    private final List<FieldAccessDescriptor.FieldDescriptor> fieldsAccessed;
    private final Map<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nestedFieldsAccessed;
    private final boolean fieldInsertionOrder;

    private AutoValue_FieldAccessDescriptor(boolean allFields, List<FieldAccessDescriptor.FieldDescriptor> fieldsAccessed, Map<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nestedFieldsAccessed, boolean fieldInsertionOrder) {
        this.allFields = allFields;
        this.fieldsAccessed = fieldsAccessed;
        this.nestedFieldsAccessed = nestedFieldsAccessed;
        this.fieldInsertionOrder = fieldInsertionOrder;
    }

    @Override
    public boolean getAllFields() {
        return this.allFields;
    }

    @Override
    public List<FieldAccessDescriptor.FieldDescriptor> getFieldsAccessed() {
        return this.fieldsAccessed;
    }

    @Override
    public Map<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> getNestedFieldsAccessed() {
        return this.nestedFieldsAccessed;
    }

    @Override
    public boolean getFieldInsertionOrder() {
        return this.fieldInsertionOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FieldAccessDescriptor) {
            FieldAccessDescriptor that = (FieldAccessDescriptor)o;
            return this.allFields == that.getAllFields() && this.fieldsAccessed.equals(that.getFieldsAccessed()) && this.nestedFieldsAccessed.equals(that.getNestedFieldsAccessed()) && this.fieldInsertionOrder == that.getFieldInsertionOrder();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.allFields ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.fieldsAccessed.hashCode();
        h$ *= 1000003;
        h$ ^= this.nestedFieldsAccessed.hashCode();
        h$ *= 1000003;
        return h$ ^= this.fieldInsertionOrder ? 1231 : 1237;
    }

    @Override
    FieldAccessDescriptor.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FieldAccessDescriptor.Builder {
        private Boolean allFields;
        private List<FieldAccessDescriptor.FieldDescriptor> fieldsAccessed;
        private Map<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nestedFieldsAccessed;
        private Boolean fieldInsertionOrder;

        Builder() {
        }

        private Builder(FieldAccessDescriptor source) {
            this.allFields = source.getAllFields();
            this.fieldsAccessed = source.getFieldsAccessed();
            this.nestedFieldsAccessed = source.getNestedFieldsAccessed();
            this.fieldInsertionOrder = source.getFieldInsertionOrder();
        }

        @Override
        FieldAccessDescriptor.Builder setAllFields(boolean allFields) {
            this.allFields = allFields;
            return this;
        }

        @Override
        FieldAccessDescriptor.Builder setFieldsAccessed(List<FieldAccessDescriptor.FieldDescriptor> fieldsAccessed) {
            if (fieldsAccessed == null) {
                throw new NullPointerException("Null fieldsAccessed");
            }
            this.fieldsAccessed = fieldsAccessed;
            return this;
        }

        @Override
        FieldAccessDescriptor.Builder setNestedFieldsAccessed(Map<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nestedFieldsAccessed) {
            if (nestedFieldsAccessed == null) {
                throw new NullPointerException("Null nestedFieldsAccessed");
            }
            this.nestedFieldsAccessed = nestedFieldsAccessed;
            return this;
        }

        @Override
        FieldAccessDescriptor.Builder setFieldInsertionOrder(boolean fieldInsertionOrder) {
            this.fieldInsertionOrder = fieldInsertionOrder;
            return this;
        }

        @Override
        FieldAccessDescriptor build() {
            String missing = "";
            if (this.allFields == null) {
                missing = missing + " allFields";
            }
            if (this.fieldsAccessed == null) {
                missing = missing + " fieldsAccessed";
            }
            if (this.nestedFieldsAccessed == null) {
                missing = missing + " nestedFieldsAccessed";
            }
            if (this.fieldInsertionOrder == null) {
                missing = missing + " fieldInsertionOrder";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FieldAccessDescriptor(this.allFields, this.fieldsAccessed, this.nestedFieldsAccessed, this.fieldInsertionOrder);
        }
    }
}

