/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import org.apache.beam.sdk.schemas.Schema;

final class AutoValue_Schema_Field
extends Schema.Field {
    private final String name;
    private final String description;
    private final Schema.FieldType type;

    private AutoValue_Schema_Field(String name, String description, Schema.FieldType type) {
        this.name = name;
        this.description = description;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Schema.FieldType getType() {
        return this.type;
    }

    public String toString() {
        return "Field{name=" + this.name + ", description=" + this.description + ", type=" + this.type + "}";
    }

    @Override
    public Schema.Field.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Schema.Field.Builder {
        private String name;
        private String description;
        private Schema.FieldType type;

        Builder() {
        }

        private Builder(Schema.Field source) {
            this.name = source.getName();
            this.description = source.getDescription();
            this.type = source.getType();
        }

        @Override
        public Schema.Field.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Schema.Field.Builder setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public Schema.Field.Builder setType(Schema.FieldType type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public Schema.Field build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.description == null) {
                missing = missing + " description";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Schema_Field(this.name, this.description, this.type);
        }
    }
}

