/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.AutoOneOf_FieldAccessDescriptor_FieldDescriptor_Qualifier;
import org.apache.beam.sdk.schemas.AutoValue_FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.AutoValue_FieldAccessDescriptor_FieldDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.parser.FieldAccessDescriptorParser;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Sets;

@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoValue
public abstract class FieldAccessDescriptor
implements Serializable {
    public abstract boolean getAllFields();

    public abstract List<FieldDescriptor> getFieldsAccessed();

    public abstract Map<FieldDescriptor, FieldAccessDescriptor> getNestedFieldsAccessed();

    public abstract boolean getFieldInsertionOrder();

    abstract Builder toBuilder();

    static Builder builder() {
        return new AutoValue_FieldAccessDescriptor.Builder().setAllFields(false).setFieldInsertionOrder(false).setFieldsAccessed(Collections.emptyList()).setNestedFieldsAccessed(Collections.emptyMap());
    }

    public static FieldAccessDescriptor withAllFields() {
        return FieldAccessDescriptor.builder().setAllFields(true).build();
    }

    public static FieldAccessDescriptor withFieldNames(String ... names) {
        return FieldAccessDescriptor.withFieldNames(Arrays.asList(names));
    }

    public static FieldAccessDescriptor withFieldNames(Iterable<String> fieldNames) {
        List<FieldAccessDescriptor> fields = StreamSupport.stream(fieldNames.spliterator(), false).map(FieldAccessDescriptorParser::parse).collect(Collectors.toList());
        return FieldAccessDescriptor.union(fields);
    }

    public static FieldAccessDescriptor withFieldIds(Integer ... ids) {
        return FieldAccessDescriptor.withFieldIds(Arrays.asList(ids));
    }

    public static FieldAccessDescriptor withFieldIds(Iterable<Integer> ids) {
        List<FieldDescriptor> fields = StreamSupport.stream(ids.spliterator(), false).map(n -> FieldDescriptor.builder().setFieldId((Integer)n).build()).collect(Collectors.toList());
        return FieldAccessDescriptor.withFields(fields);
    }

    public static FieldAccessDescriptor withFields(FieldDescriptor ... fields) {
        return FieldAccessDescriptor.withFields(Arrays.asList(fields));
    }

    public static FieldAccessDescriptor withFields(Iterable<FieldDescriptor> fields) {
        return FieldAccessDescriptor.builder().setFieldsAccessed(Lists.newArrayList(fields)).build();
    }

    private static FieldAccessDescriptor union(Iterable<FieldAccessDescriptor> fieldAccessDescriptors) {
        LinkedHashSet<FieldDescriptor> fieldsAccessed = Sets.newLinkedHashSet();
        ArrayListMultimap<FieldDescriptor, FieldAccessDescriptor> nestedFieldsAccessed = ArrayListMultimap.create();
        for (FieldAccessDescriptor fieldAccessDescriptor : fieldAccessDescriptors) {
            if (fieldAccessDescriptor.getAllFields()) {
                return FieldAccessDescriptor.withAllFields();
            }
            for (FieldDescriptor fieldDescriptor : fieldAccessDescriptor.getFieldsAccessed()) {
                fieldsAccessed.add(fieldDescriptor);
                nestedFieldsAccessed.removeAll(fieldDescriptor);
            }
            for (Map.Entry entry : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
                FieldDescriptor field = (FieldDescriptor)entry.getKey();
                nestedFieldsAccessed.put(field, (FieldAccessDescriptor)entry.getValue());
            }
        }
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFields(fieldsAccessed);
        for (Map.Entry entry : nestedFieldsAccessed.asMap().entrySet()) {
            if (fieldsAccessed.contains(entry.getKey())) continue;
            fieldAccessDescriptor = fieldAccessDescriptor.withNestedField((FieldDescriptor)entry.getKey(), FieldAccessDescriptor.union(entry.getValue()));
        }
        return fieldAccessDescriptor;
    }

    public static FieldAccessDescriptor create() {
        return FieldAccessDescriptor.builder().build();
    }

    public FieldAccessDescriptor withNestedField(int nestedFieldId, FieldAccessDescriptor fieldAccess) {
        FieldDescriptor field = FieldDescriptor.builder().setFieldId(nestedFieldId).build();
        return this.withNestedField(field, fieldAccess);
    }

    public FieldAccessDescriptor withNestedField(String nestedFieldName, FieldAccessDescriptor fieldAccess) {
        FieldDescriptor field = FieldDescriptor.builder().setFieldName(nestedFieldName).build();
        return this.withNestedField(field, fieldAccess);
    }

    public FieldAccessDescriptor withNestedField(FieldDescriptor field, FieldAccessDescriptor fieldAccess) {
        ImmutableMap<FieldDescriptor, FieldAccessDescriptor> newNestedFieldAccess = ImmutableMap.builder().putAll(this.getNestedFieldsAccessed()).put(field, fieldAccess).build();
        return this.toBuilder().setNestedFieldsAccessed(newNestedFieldAccess).build();
    }

    public FieldAccessDescriptor withOrderByFieldInsertionOrder() {
        return this.toBuilder().setFieldInsertionOrder(true).build();
    }

    public List<Integer> fieldIdsAccessed() {
        return this.getFieldsAccessed().stream().map(FieldDescriptor::getFieldId).collect(Collectors.toList());
    }

    public Set<String> fieldNamesAccessed() {
        return this.getFieldsAccessed().stream().map(FieldDescriptor::getFieldName).collect(Collectors.toSet());
    }

    public Map<Integer, FieldAccessDescriptor> nestedFieldsById() {
        return this.getNestedFieldsAccessed().entrySet().stream().collect(Collectors.toMap(f -> ((FieldDescriptor)f.getKey()).getFieldId(), f -> (FieldAccessDescriptor)f.getValue()));
    }

    public Map<String, FieldAccessDescriptor> nestedFieldsByName() {
        return this.getNestedFieldsAccessed().entrySet().stream().collect(Collectors.toMap(f -> ((FieldDescriptor)f.getKey()).getFieldName(), f -> (FieldAccessDescriptor)f.getValue()));
    }

    public boolean referencesSingleField() {
        if (this.getAllFields()) {
            return false;
        }
        if (this.getFieldsAccessed().size() == 1 && this.getNestedFieldsAccessed().isEmpty()) {
            return true;
        }
        if (this.getFieldsAccessed().isEmpty() && this.getNestedFieldsAccessed().size() == 1) {
            return this.getNestedFieldsAccessed().values().iterator().next().referencesSingleField();
        }
        return false;
    }

    public FieldAccessDescriptor resolve(Schema schema) {
        List<FieldDescriptor> resolvedFieldIdsAccessed = this.resolveDirectFieldsAccessed(schema);
        Map<FieldDescriptor, FieldAccessDescriptor> resolvedNestedFieldsAccessed = this.resolveNestedFieldsAccessed(schema);
        Preconditions.checkState(!this.getAllFields() || resolvedNestedFieldsAccessed.isEmpty(), "nested fields cannot be set if allFields is also set");
        resolvedFieldIdsAccessed.removeAll(resolvedNestedFieldsAccessed.keySet());
        return FieldAccessDescriptor.builder().setAllFields(this.getAllFields()).setFieldsAccessed(resolvedFieldIdsAccessed).setNestedFieldsAccessed(resolvedNestedFieldsAccessed).build();
    }

    private List<FieldDescriptor> resolveDirectFieldsAccessed(Schema schema) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor field : this.getFieldsAccessed()) {
            FieldAccessDescriptor.validateFieldDescriptor(schema, field);
            if (field.getFieldId() == null) {
                field = field.toBuilder().setFieldId(schema.indexOf(field.getFieldName())).build();
            }
            if (field.getFieldName() == null) {
                field = field.toBuilder().setFieldName(schema.nameOf(field.getFieldId())).build();
            }
            field = this.fillInMissingQualifiers(field, schema);
            fields.add(field);
        }
        if (!this.getFieldInsertionOrder()) {
            Collections.sort(fields, Comparator.comparing(FieldDescriptor::getFieldId));
        }
        return fields;
    }

    private Map<FieldDescriptor, FieldAccessDescriptor> resolveNestedFieldsAccessed(Schema schema) {
        LinkedHashMap<FieldDescriptor, FieldAccessDescriptor> nestedFields;
        if (this.getFieldInsertionOrder()) {
            nestedFields = Maps.newLinkedHashMap();
        } else {
            Function extract = FieldDescriptor::getFieldId;
            nestedFields = Maps.newTreeMap(Comparator.comparing(extract));
        }
        for (Map.Entry<FieldDescriptor, FieldAccessDescriptor> entry : this.getNestedFieldsAccessed().entrySet()) {
            FieldDescriptor fieldDescriptor = entry.getKey();
            FieldAccessDescriptor fieldAccessDescriptor = entry.getValue();
            FieldAccessDescriptor.validateFieldDescriptor(schema, fieldDescriptor);
            if (entry.getKey().getFieldId() == null) {
                fieldDescriptor = fieldDescriptor.toBuilder().setFieldId(schema.indexOf(fieldDescriptor.getFieldName())).build();
            } else if (entry.getKey().getFieldName() == null) {
                fieldDescriptor = fieldDescriptor.toBuilder().setFieldName(schema.nameOf(fieldDescriptor.getFieldId())).build();
            }
            fieldDescriptor = this.fillInMissingQualifiers(fieldDescriptor, schema);
            fieldAccessDescriptor = fieldAccessDescriptor.resolve(this.getFieldDescriptorSchema(fieldDescriptor, schema));
            nestedFields.merge(fieldDescriptor, fieldAccessDescriptor, (d1, d2) -> FieldAccessDescriptor.union(ImmutableList.of(d1, d2)));
        }
        return nestedFields;
    }

    private FieldDescriptor fillInMissingQualifiers(FieldDescriptor fieldDescriptor, Schema schema) {
        Schema.FieldType fieldType = schema.getField(fieldDescriptor.getFieldId()).getType();
        Iterator<FieldDescriptor.Qualifier> qualifierIt = fieldDescriptor.getQualifiers().iterator();
        ArrayList<FieldDescriptor.Qualifier> qualifiers = Lists.newArrayList();
        while (fieldType.getTypeName().isCollectionType() || fieldType.getTypeName().isMapType()) {
            FieldDescriptor.Qualifier qualifier;
            FieldDescriptor.Qualifier qualifier2 = qualifier = qualifierIt.hasNext() ? qualifierIt.next() : null;
            if (fieldType.getTypeName().isCollectionType()) {
                qualifier = qualifier == null ? FieldDescriptor.Qualifier.of(FieldDescriptor.ListQualifier.ALL) : qualifier;
                Preconditions.checkArgument(qualifier.getKind().equals((Object)FieldDescriptor.Qualifier.Kind.LIST));
                Preconditions.checkArgument(qualifier.getList().equals((Object)FieldDescriptor.ListQualifier.ALL));
                qualifiers.add(qualifier);
                fieldType = fieldType.getCollectionElementType();
                continue;
            }
            if (!fieldType.getTypeName().isMapType()) continue;
            qualifier = qualifier == null ? FieldDescriptor.Qualifier.of(FieldDescriptor.MapQualifier.ALL) : qualifier;
            Preconditions.checkArgument(qualifier.getKind().equals((Object)FieldDescriptor.Qualifier.Kind.MAP));
            Preconditions.checkArgument(qualifier.getMap().equals((Object)FieldDescriptor.MapQualifier.ALL));
            qualifiers.add(qualifier);
            fieldType = fieldType.getMapValueType();
        }
        return fieldDescriptor.toBuilder().setQualifiers(qualifiers).build();
    }

    private Schema getFieldDescriptorSchema(FieldDescriptor fieldDescriptor, Schema schema) {
        Schema.FieldType fieldType = schema.getField(fieldDescriptor.getFieldId()).getType();
        while (fieldType.getTypeName().isCollectionType() || fieldType.getTypeName().isMapType()) {
            if (fieldType.getTypeName().isCollectionType()) {
                fieldType = fieldType.getCollectionElementType();
                continue;
            }
            if (!fieldType.getTypeName().isMapType()) continue;
            fieldType = fieldType.getMapValueType();
        }
        return FieldAccessDescriptor.getFieldSchema(fieldType);
    }

    private static Schema getFieldSchema(Schema.FieldType type) {
        if (Schema.TypeName.ROW.equals((Object)type.getTypeName())) {
            return type.getRowSchema();
        }
        if (Schema.TypeName.ARRAY.equals((Object)type.getTypeName()) && Schema.TypeName.ROW.equals((Object)type.getCollectionElementType().getTypeName())) {
            return type.getCollectionElementType().getRowSchema();
        }
        if (Schema.TypeName.MAP.equals((Object)type.getTypeName()) && Schema.TypeName.ROW.equals((Object)type.getMapValueType().getTypeName())) {
            return type.getMapValueType().getRowSchema();
        }
        throw new IllegalArgumentException("FieldType " + type + " must be either a row or a container containing rows");
    }

    private static void validateFieldDescriptor(Schema schema, FieldDescriptor fieldDescriptor) {
        Integer fieldId = fieldDescriptor.getFieldId();
        if (fieldId != null && (fieldId < 0 || fieldId >= schema.getFieldCount())) {
            throw new IllegalArgumentException("Invalid field id " + fieldId + " for schema " + schema);
        }
        Schema.Field field = fieldId != null ? schema.getField(fieldId) : schema.getField(fieldDescriptor.getFieldName());
        Schema.FieldType fieldType = field.getType();
        block4: for (FieldDescriptor.Qualifier qualifier : fieldDescriptor.getQualifiers()) {
            switch (qualifier.getKind()) {
                case LIST: {
                    Preconditions.checkArgument(qualifier.getList().equals((Object)FieldDescriptor.ListQualifier.ALL));
                    Preconditions.checkArgument(fieldType.getTypeName().equals((Object)Schema.TypeName.ARRAY));
                    fieldType = fieldType.getCollectionElementType();
                    continue block4;
                }
                case MAP: {
                    Preconditions.checkArgument(qualifier.getMap().equals((Object)FieldDescriptor.MapQualifier.ALL));
                    Preconditions.checkArgument(fieldType.getTypeName().equals((Object)Schema.TypeName.MAP));
                    fieldType = fieldType.getMapValueType();
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected qualifier type " + (Object)((Object)qualifier.getKind()));
        }
    }

    public String toString() {
        if (this.getAllFields()) {
            return "*";
        }
        List singleSelectors = this.getFieldsAccessed().stream().map(FieldDescriptor::getFieldName).collect(Collectors.toList());
        List nestedSelectors = this.getNestedFieldsAccessed().entrySet().stream().map(e -> ((FieldDescriptor)e.getKey()).getFieldName() + "." + ((FieldAccessDescriptor)e.getValue()).toString()).collect(Collectors.toList());
        return String.join((CharSequence)", ", Iterables.concat(singleSelectors, nestedSelectors));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setAllFields(boolean var1);

        abstract Builder setFieldsAccessed(List<FieldDescriptor> var1);

        abstract Builder setNestedFieldsAccessed(Map<FieldDescriptor, FieldAccessDescriptor> var1);

        abstract Builder setFieldInsertionOrder(boolean var1);

        abstract FieldAccessDescriptor build();
    }

    @AutoValue
    public static abstract class FieldDescriptor
    implements Serializable {
        @Nullable
        public abstract String getFieldName();

        @Nullable
        public abstract Integer getFieldId();

        public abstract List<Qualifier> getQualifiers();

        public static Builder builder() {
            return new AutoValue_FieldAccessDescriptor_FieldDescriptor.Builder().setQualifiers(Collections.emptyList());
        }

        abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setFieldName(@Nullable String var1);

            public abstract Builder setFieldId(@Nullable Integer var1);

            public abstract Builder setQualifiers(List<Qualifier> var1);

            public abstract FieldDescriptor build();
        }

        @AutoOneOf(value=Kind.class)
        public static abstract class Qualifier
        implements Serializable {
            public abstract Kind getKind();

            public abstract ListQualifier getList();

            public abstract MapQualifier getMap();

            public static Qualifier of(ListQualifier qualifier) {
                return AutoOneOf_FieldAccessDescriptor_FieldDescriptor_Qualifier.list(qualifier);
            }

            public static Qualifier of(MapQualifier qualifier) {
                return AutoOneOf_FieldAccessDescriptor_FieldDescriptor_Qualifier.map(qualifier);
            }

            public static enum Kind {
                LIST,
                MAP;

            }
        }

        public static enum MapQualifier {
            ALL;

        }

        public static enum ListQualifier {
            ALL;

        }
    }
}

