/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FieldValueTypeInformationFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.UserTypeCreatorFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

class FromRowUsingCreator<T>
implements SerializableFunction<Row, T> {
    private final Class<T> clazz;
    private final Factory<SchemaUserTypeCreator> schemaTypeCreatorFactory;
    private final Factory<List<FieldValueTypeInformation>> fieldValueTypeInformationFactory;

    public FromRowUsingCreator(Class<T> clazz, UserTypeCreatorFactory schemaTypeUserTypeCreatorFactory, FieldValueTypeInformationFactory fieldValueTypeInformationFactory) {
        this.clazz = clazz;
        this.schemaTypeCreatorFactory = new CachingFactory<SchemaUserTypeCreator>(schemaTypeUserTypeCreatorFactory);
        this.fieldValueTypeInformationFactory = new CachingFactory<List<FieldValueTypeInformation>>(fieldValueTypeInformationFactory);
    }

    @Override
    public T apply(Row row) {
        return this.fromRow(row, this.clazz, this.fieldValueTypeInformationFactory);
    }

    public <ValueT> ValueT fromRow(Row row, Class<ValueT> clazz, Factory<List<FieldValueTypeInformation>> typeFactory) {
        Object target;
        if (row instanceof RowWithGetters && (target = ((RowWithGetters)row).getGetterTarget()).getClass().equals(clazz)) {
            return (ValueT)target;
        }
        Object[] params = new Object[row.getFieldCount()];
        Schema schema = row.getSchema();
        List<FieldValueTypeInformation> typeInformations = typeFactory.create(clazz, schema);
        Preconditions.checkState(typeInformations.size() == row.getFieldCount(), "Did not have a matching number of type informations and fields.");
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Schema.FieldType type = schema.getField(i).getType();
            FieldValueTypeInformation typeInformation = Preconditions.checkNotNull(typeInformations.get(i));
            params[i] = this.fromValue(type, row.getValue(i), typeInformation.getRawType(), typeInformation.getElementType(), typeInformation.getMapKeyType(), typeInformation.getMapValueType(), typeFactory);
        }
        SchemaUserTypeCreator creator = this.schemaTypeCreatorFactory.create(clazz, schema);
        return (ValueT)creator.create(params);
    }

    @Nullable
    private <ValueT> ValueT fromValue(Schema.FieldType type, ValueT value, Type fieldType, FieldValueTypeInformation elementType, FieldValueTypeInformation keyType, FieldValueTypeInformation valueType, Factory<List<FieldValueTypeInformation>> typeFactory) {
        if (value == null) {
            return null;
        }
        if (Schema.TypeName.ROW.equals((Object)type.getTypeName())) {
            return this.fromRow((Row)value, (Class)fieldType, typeFactory);
        }
        if (Schema.TypeName.ARRAY.equals((Object)type.getTypeName())) {
            return (ValueT)this.fromListValue(type.getCollectionElementType(), (List)value, elementType, typeFactory);
        }
        if (Schema.TypeName.MAP.equals((Object)type.getTypeName())) {
            return (ValueT)this.fromMapValue(type.getMapKeyType(), type.getMapValueType(), (Map)value, keyType, valueType, typeFactory);
        }
        return value;
    }

    private <ElementT> List fromListValue(Schema.FieldType elementType, List<ElementT> rowList, FieldValueTypeInformation elementTypeInformation, Factory<List<FieldValueTypeInformation>> typeFactory) {
        ArrayList<ElementT> list = Lists.newArrayList();
        for (ElementT element : rowList) {
            list.add(this.fromValue(elementType, element, elementTypeInformation.getType().getType(), elementTypeInformation.getElementType(), elementTypeInformation.getMapKeyType(), elementTypeInformation.getMapValueType(), typeFactory));
        }
        return list;
    }

    private Map<?, ?> fromMapValue(Schema.FieldType keyType, Schema.FieldType valueType, Map<?, ?> map, FieldValueTypeInformation keyTypeInformation, FieldValueTypeInformation valueTypeInformation, Factory<List<FieldValueTypeInformation>> typeFactory) {
        HashMap<?, ?> newMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = this.fromValue(keyType, entry.getKey(), keyTypeInformation.getType().getType(), keyTypeInformation.getElementType(), keyTypeInformation.getMapKeyType(), keyTypeInformation.getMapValueType(), typeFactory);
            Object value = this.fromValue(valueType, entry.getValue(), valueTypeInformation.getType().getType(), valueTypeInformation.getElementType(), valueTypeInformation.getMapKeyType(), valueTypeInformation.getMapValueType(), typeFactory);
            newMap.put(key, value);
        }
        return newMap;
    }
}

