/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldValueGetterFactory;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueSetterFactory;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FieldValueTypeInformationFactory;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SetterBasedCreatorFactory;
import org.apache.beam.sdk.schemas.UserTypeCreatorFactory;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class JavaBeanSchema
extends GetterBasedSchemaProvider {
    @Override
    public <T> Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(typeDescriptor.getRawType(), GetterTypeSupplier.INSTANCE);
        if (ReflectUtils.getAnnotatedCreateMethod(typeDescriptor.getRawType()) == null && ReflectUtils.getAnnotatedConstructor(typeDescriptor.getRawType()) == null) {
            JavaBeanUtils.validateJavaBean(GetterTypeSupplier.INSTANCE.get(typeDescriptor.getRawType(), schema), SetterTypeSupplier.INSTANCE.get(typeDescriptor.getRawType(), schema));
        }
        return schema;
    }

    @Override
    public FieldValueGetterFactory fieldValueGetterFactory() {
        return (targetClass, schema) -> JavaBeanUtils.getGetters(targetClass, schema, GetterTypeSupplier.INSTANCE);
    }

    @Override
    UserTypeCreatorFactory schemaTypeCreatorFactory() {
        SetterBasedCreatorFactory setterBasedFactory = new SetterBasedCreatorFactory(new JavaBeanSetterFactory());
        return (targetClass, schema) -> {
            Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetClass);
            if (annotated != null) {
                return JavaBeanUtils.getStaticCreator(targetClass, annotated, schema, GetterTypeSupplier.INSTANCE);
            }
            Constructor constructor = ReflectUtils.getAnnotatedConstructor(targetClass);
            if (constructor != null) {
                return JavaBeanUtils.getConstructorCreator(targetClass, constructor, schema, GetterTypeSupplier.INSTANCE);
            }
            return setterBasedFactory.create(targetClass, schema);
        };
    }

    @Override
    public FieldValueTypeInformationFactory fieldValueTypeInformationFactory() {
        return (targetClass, schema) -> JavaBeanUtils.getFieldTypes(targetClass, schema, GetterTypeSupplier.INSTANCE);
    }

    public static class JavaBeanSetterFactory
    implements FieldValueSetterFactory {
        @Override
        public List<FieldValueSetter> create(Class<?> targetClass, Schema schema) {
            return JavaBeanUtils.getSetters(targetClass, schema, SetterTypeSupplier.INSTANCE);
        }
    }

    @VisibleForTesting
    public static class SetterTypeSupplier
    implements FieldValueTypeSupplier {
        private static final SetterTypeSupplier INSTANCE = new SetterTypeSupplier();

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            return ReflectUtils.getMethods(clazz).stream().filter(ReflectUtils::isSetter).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).map(FieldValueTypeInformation::forSetter).collect(Collectors.toList());
        }
    }

    @VisibleForTesting
    public static class GetterTypeSupplier
    implements FieldValueTypeSupplier {
        public static final GetterTypeSupplier INSTANCE = new GetterTypeSupplier();

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            return ReflectUtils.getMethods(clazz).stream().filter(ReflectUtils::isGetter).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).map(FieldValueTypeInformation::forGetter).map(t -> {
                SchemaFieldName fieldName = t.getMethod().getAnnotation(SchemaFieldName.class);
                return fieldName != null ? t.withName(fieldName.value()) : t;
            }).collect(Collectors.toList());
        }
    }
}

