/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.Arrays;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class LogicalTypes {

    public static class FixedBytes
    implements Schema.LogicalType<byte[], byte[]> {
        public static final String IDENTIFIER = "FixedBytes";
        private final int byteArraySize;

        private FixedBytes(int byteArraySize) {
            this.byteArraySize = byteArraySize;
        }

        public static FixedBytes of(int byteArraySize) {
            return new FixedBytes(byteArraySize);
        }

        public int getLength() {
            return this.byteArraySize;
        }

        @Override
        public String getIdentifier() {
            return IDENTIFIER;
        }

        @Override
        public String getArgument() {
            return Integer.toString(this.byteArraySize);
        }

        @Override
        public Schema.FieldType getBaseType() {
            return Schema.FieldType.BYTES;
        }

        @Override
        public byte[] toBaseType(byte[] input) {
            Preconditions.checkArgument(input.length == this.byteArraySize);
            return input;
        }

        @Override
        public byte[] toInputType(byte[] base) {
            Preconditions.checkArgument(base.length <= this.byteArraySize);
            if (base.length == this.byteArraySize) {
                return base;
            }
            return Arrays.copyOf(base, this.byteArraySize);
        }
    }

    public static abstract class PassThroughLogicalType<T>
    implements Schema.LogicalType<T, T> {
        private final String identifier;
        private final String argument;
        private final Schema.FieldType fieldType;

        protected PassThroughLogicalType(String identifier, String argument, Schema.FieldType fieldType) {
            this.identifier = identifier;
            this.argument = argument;
            this.fieldType = fieldType;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getArgument() {
            return this.argument;
        }

        @Override
        public Schema.FieldType getBaseType() {
            return this.fieldType;
        }

        @Override
        public T toBaseType(T input) {
            return input;
        }

        @Override
        public T toInputType(T base) {
            return base;
        }
    }
}

