/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.Row;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaCoder<T>
extends CustomCoder<T> {
    private final RowCoder rowCoder;
    private final SerializableFunction<T, Row> toRowFunction;
    private final SerializableFunction<Row, T> fromRowFunction;

    private SchemaCoder(Schema schema, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
        this.toRowFunction = toRowFunction;
        this.fromRowFunction = fromRowFunction;
        this.rowCoder = RowCoder.of(schema);
    }

    public static <T> SchemaCoder<T> of(Schema schema, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
        return new SchemaCoder<T>(schema, toRowFunction, fromRowFunction);
    }

    public static SchemaCoder<Row> of(Schema schema) {
        return new SchemaCoder<Row>(schema, SerializableFunctions.identity(), SerializableFunctions.identity());
    }

    public Schema getSchema() {
        return this.rowCoder.getSchema();
    }

    public SerializableFunction<Row, T> getFromRowFunction() {
        return this.fromRowFunction;
    }

    public SerializableFunction<T, Row> getToRowFunction() {
        return this.toRowFunction;
    }

    @Override
    public void encode(T value, OutputStream outStream) throws IOException {
        this.rowCoder.encode(this.toRowFunction.apply(value), outStream);
    }

    @Override
    public T decode(InputStream inStream) throws IOException {
        return this.fromRowFunction.apply(this.rowCoder.decode(inStream));
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.rowCoder.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return this.rowCoder.consistentWithEquals();
    }

    public String toString() {
        return "SchemaCoder: " + this.rowCoder.toString();
    }
}

