/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.ConvertHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Convert {
    public static <InputT> PTransform<PCollection<InputT>, PCollection<Row>> toRows() {
        return Convert.to(Row.class);
    }

    public static <OutputT> PTransform<PCollection<Row>, PCollection<OutputT>> fromRows(Class<OutputT> clazz) {
        return Convert.to(clazz);
    }

    public static <OutputT> PTransform<PCollection<Row>, PCollection<OutputT>> fromRows(TypeDescriptor<OutputT> typeDescriptor) {
        return Convert.to(typeDescriptor);
    }

    public static <InputT, OutputT> PTransform<PCollection<InputT>, PCollection<OutputT>> to(Class<OutputT> clazz) {
        return Convert.to(TypeDescriptor.of(clazz));
    }

    public static <InputT, OutputT> PTransform<PCollection<InputT>, PCollection<OutputT>> to(TypeDescriptor<OutputT> typeDescriptor) {
        return new ConvertTransform(typeDescriptor);
    }

    private static class ConvertTransform<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        TypeDescriptor<OutputT> outputTypeDescriptor;

        ConvertTransform(TypeDescriptor<OutputT> outputTypeDescriptor) {
            this.outputTypeDescriptor = outputTypeDescriptor;
        }

        @Nullable
        private static Schema getBoxedNestedSchema(Schema schema) {
            if (schema.getFieldCount() != 1) {
                return null;
            }
            Schema.FieldType fieldType = schema.getField(0).getType();
            if (!fieldType.getTypeName().isCompositeType()) {
                return null;
            }
            return fieldType.getRowSchema();
        }

        @Override
        public PCollection<OutputT> expand(PCollection<InputT> input) {
            PCollection<Object> output;
            boolean unbox;
            if (!input.hasSchema()) {
                throw new RuntimeException("Convert requires a schema on the input.");
            }
            SchemaRegistry registry = input.getPipeline().getSchemaRegistry();
            final ConvertHelpers.ConvertedSchemaInformation<OutputT> converted = ConvertHelpers.getConvertedSchemaInformation(input.getSchema(), this.outputTypeDescriptor, registry);
            boolean bl = unbox = converted.unboxedType != null;
            if (converted.outputSchemaCoder != null) {
                output = (PCollection<Object>)input.apply(ParDo.of(new DoFn<InputT, OutputT>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<OutputT> o) {
                        Row input = unbox ? row.getValue(0) : row;
                        o.output(converted.outputSchemaCoder.getFromRowFunction().apply(input));
                    }
                }));
                output = output.setSchema(converted.outputSchemaCoder.getSchema(), converted.outputSchemaCoder.getToRowFunction(), converted.outputSchemaCoder.getFromRowFunction());
            } else {
                final SerializableFunction convertPrimitive = ConvertHelpers.getConvertPrimitive(converted.unboxedType, this.outputTypeDescriptor);
                output = (PCollection)input.apply(ParDo.of(new DoFn<InputT, OutputT>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<OutputT> o) {
                        o.output(convertPrimitive.apply(row.getValue(0)));
                    }
                }));
                output.setTypeDescriptor(this.outputTypeDescriptor);
            }
            return output;
        }
    }
}

