/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Filter_Inner_FilterDescription;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Filter {
    public static <T> Inner<T> create() {
        return new Inner();
    }

    public static class Inner<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final List<FilterDescription<?>> filters = Lists.newArrayList();

        public <FieldT> Inner<T> whereFieldName(String fieldName, SerializableFunction<FieldT, Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldNames(fieldName)).setPredicate(predicate).setSelectsSingleField(true).build());
            return this;
        }

        public <FieldT> Inner<T> whereFieldId(int fieldId, SerializableFunction<FieldT, Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldIds(fieldId)).setPredicate(predicate).setSelectsSingleField(true).build());
            return this;
        }

        public Inner<T> whereFieldNames(List<String> fieldNames, SerializableFunction<Row, Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldNames(fieldNames)).setPredicate(predicate).setSelectsSingleField(false).build());
            return this;
        }

        public Inner<T> whereFieldIds(List<Integer> fieldIds, SerializableFunction<Row, Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldIds(fieldIds)).setPredicate(predicate).setSelectsSingleField(false).build());
            return this;
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            final Schema inputSchema = input.getSchema();
            final List resolvedFilters = this.filters.stream().map(f -> f.toBuilder().setFieldAccessDescriptor(f.getFieldAccessDescriptor().resolve(inputSchema)).build()).map(f -> f.toBuilder().setSelectedSchema(SelectHelpers.getOutputSchema(inputSchema, f.getFieldAccessDescriptor())).build()).collect(Collectors.toList());
            return (PCollection)input.apply(ParDo.of(new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> o) {
                    for (FilterDescription filter : resolvedFilters) {
                        SerializableFunction predicate;
                        Row selected = SelectHelpers.selectRow(row, filter.getFieldAccessDescriptor(), inputSchema, filter.getSelectedSchema());
                        if (!(filter.getSelectsSingleField() ? (predicate = filter.getPredicate()).apply(selected.getValue(0)) == false : (predicate = filter.getPredicate()).apply(selected) == false)) continue;
                        return;
                    }
                    o.output(row);
                }
            }));
        }

        @AutoValue
        static abstract class FilterDescription<FieldT>
        implements Serializable {
            FilterDescription() {
            }

            abstract FieldAccessDescriptor getFieldAccessDescriptor();

            abstract SerializableFunction<FieldT, Boolean> getPredicate();

            @Nullable
            abstract Schema getSelectedSchema();

            abstract boolean getSelectsSingleField();

            abstract Builder<FieldT> toBuilder();

            @AutoValue.Builder
            static abstract class Builder<FieldT> {
                Builder() {
                }

                abstract Builder<FieldT> setFieldAccessDescriptor(FieldAccessDescriptor var1);

                abstract Builder<FieldT> setPredicate(SerializableFunction<FieldT, Boolean> var1);

                abstract Builder<FieldT> setSelectedSchema(@Nullable Schema var1);

                abstract Builder<FieldT> setSelectsSingleField(boolean var1);

                abstract FilterDescription<FieldT> build();
            }
        }
    }
}

