/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.apache.commons.compress.utils.Lists;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableCollection;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class RenameFields {
    public static <T> Inner<T> create() {
        return new Inner();
    }

    private static Schema.FieldType renameFieldType(Schema.FieldType inputType, Collection<RenamePair> renames) {
        switch (inputType.getTypeName()) {
            case ROW: {
                return Schema.FieldType.row(RenameFields.renameSchema(inputType.getRowSchema(), renames));
            }
            case ARRAY: {
                return Schema.FieldType.array(RenameFields.renameFieldType(inputType.getCollectionElementType(), renames));
            }
            case MAP: {
                return Schema.FieldType.map(RenameFields.renameFieldType(inputType.getMapKeyType(), renames), RenameFields.renameFieldType(inputType.getMapValueType(), renames));
            }
        }
        return inputType;
    }

    private static Schema renameSchema(Schema inputSchema, Collection<RenamePair> renames) {
        HashMap<Integer, String> topLevelRenames = Maps.newHashMap();
        ArrayListMultimap<Integer, RenamePair> nestedRenames = ArrayListMultimap.create();
        for (RenamePair rename : renames) {
            FieldAccessDescriptor access = rename.fieldAccessDescriptor;
            if (!access.fieldIdsAccessed().isEmpty()) {
                Integer fieldId = Iterables.getOnlyElement(access.fieldIdsAccessed());
                topLevelRenames.put(fieldId, rename.newName);
                continue;
            }
            Map.Entry<Integer, FieldAccessDescriptor> nestedAccess = Iterables.getOnlyElement(access.nestedFieldsById().entrySet());
            nestedRenames.put(nestedAccess.getKey(), new RenamePair(nestedAccess.getValue(), rename.newName));
        }
        Schema.Builder builder = Schema.builder();
        for (int i = 0; i < inputSchema.getFieldCount(); ++i) {
            Schema.Field field = inputSchema.getField(i);
            Schema.FieldType fieldType = field.getType();
            String newName = topLevelRenames.getOrDefault(i, field.getName());
            Collection<RenamePair> nestedFieldRenames = nestedRenames.asMap().get(i);
            if (nestedFieldRenames != null) {
                builder.addField(newName, RenameFields.renameFieldType(fieldType, nestedFieldRenames));
                continue;
            }
            builder.addField(newName, fieldType);
        }
        return builder.build();
    }

    public static class Inner<T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        private List<RenamePair> renames;

        private Inner() {
            this.renames = Lists.newArrayList();
        }

        private Inner(List<RenamePair> renames) {
            this.renames = renames;
        }

        public Inner<T> rename(String field, String newName) {
            return this.rename(FieldAccessDescriptor.withFieldNames(field), newName);
        }

        public Inner<T> rename(FieldAccessDescriptor field, String newName) {
            ImmutableCollection newList = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.renames)).add(new RenamePair(field, newName))).build();
            return new Inner<T>((List<RenamePair>)((Object)newList));
        }

        @Override
        public PCollection<Row> expand(PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            List pairs = this.renames.stream().map(r -> r.resolve(inputSchema)).collect(Collectors.toList());
            final Schema outputSchema = RenameFields.renameSchema(inputSchema, pairs);
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<Row> o) {
                    o.output(Row.withSchema(outputSchema).attachValues(row.getValues()).build());
                }
            }))).setRowSchema(outputSchema);
        }
    }

    private static class RenamePair
    implements Serializable {
        private final FieldAccessDescriptor fieldAccessDescriptor;
        private final String newName;

        RenamePair(FieldAccessDescriptor fieldAccessDescriptor, String newName) {
            this.fieldAccessDescriptor = fieldAccessDescriptor;
            this.newName = newName;
        }

        RenamePair resolve(Schema schema) {
            FieldAccessDescriptor resolved = this.fieldAccessDescriptor.resolve(schema);
            if (!resolved.referencesSingleField()) {
                throw new IllegalArgumentException(resolved + " references multiple fields.");
            }
            return new RenamePair(resolved, this.newName);
        }
    }
}

