/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericFixed;
import org.apache.beam.repackaged.core.net.bytebuddy.ByteBuddy;
import org.apache.beam.repackaged.core.net.bytebuddy.NamingStrategy;
import org.apache.beam.repackaged.core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.description.method.MethodList;
import org.apache.beam.repackaged.core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.repackaged.core.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.repackaged.core.net.bytebuddy.utility.RandomString;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ClassUtils;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class ByteBuddyUtils {
    private static final TypeDescription.ForLoadedType ARRAYS_TYPE = new TypeDescription.ForLoadedType(Arrays.class);
    private static final TypeDescription.ForLoadedType ARRAY_UTILS_TYPE = new TypeDescription.ForLoadedType(ArrayUtils.class);
    private static final TypeDescription.ForLoadedType BYTE_ARRAY_TYPE = new TypeDescription.ForLoadedType(byte[].class);
    private static final TypeDescription.ForLoadedType BYTE_BUFFER_TYPE = new TypeDescription.ForLoadedType(ByteBuffer.class);
    private static final TypeDescription.ForLoadedType CHAR_SEQUENCE_TYPE = new TypeDescription.ForLoadedType(CharSequence.class);
    private static final TypeDescription.ForLoadedType INSTANT_TYPE = new TypeDescription.ForLoadedType(Instant.class);
    private static final TypeDescription.ForLoadedType LIST_TYPE = new TypeDescription.ForLoadedType(List.class);
    private static final TypeDescription.ForLoadedType READABLE_INSTANT_TYPE = new TypeDescription.ForLoadedType(ReadableInstant.class);

    ByteBuddyUtils() {
    }

    static DynamicType.Builder<FieldValueGetter> subclassGetterInterface(ByteBuddy byteBuddy, Type objectType, Type fieldType) {
        TypeDescription.Generic getterGenericType = TypeDescription.Generic.Builder.parameterizedType(FieldValueGetter.class, objectType, fieldType).build();
        return byteBuddy.with(new InjectPackageStrategy((Class)objectType)).subclass(getterGenericType);
    }

    static DynamicType.Builder<FieldValueSetter> subclassSetterInterface(ByteBuddy byteBuddy, Type objectType, Type fieldType) {
        TypeDescription.Generic setterGenericType = TypeDescription.Generic.Builder.parameterizedType(FieldValueSetter.class, objectType, fieldType).build();
        return byteBuddy.with(new InjectPackageStrategy((Class)objectType)).subclass(setterGenericType);
    }

    static class InvokeUserCreateInstruction
    implements Implementation {
        protected final List<FieldValueTypeInformation> fields;
        protected final Class targetClass;
        protected final List<Parameter> parameters;
        protected final Map<Integer, Integer> fieldMapping;

        protected InvokeUserCreateInstruction(List<FieldValueTypeInformation> fields, Class targetClass, List<Parameter> parameters) {
            int i;
            this.fields = fields;
            this.targetClass = targetClass;
            this.parameters = parameters;
            HashMap<String, Integer> fieldsByLogicalName = Maps.newHashMap();
            HashMap<String, Integer> fieldsByJavaClassMember = Maps.newHashMap();
            for (i = 0; i < fields.size(); ++i) {
                FieldValueTypeInformation fieldValue = Preconditions.checkNotNull(fields.get(i));
                fieldsByLogicalName.put(fieldValue.getName(), i);
                if (fieldValue.getField() != null) {
                    fieldsByJavaClassMember.put(fieldValue.getField().getName(), i);
                    continue;
                }
                if (fieldValue.getMethod() == null) continue;
                String name = ReflectUtils.stripPrefix(fieldValue.getMethod().getName(), "set");
                fieldsByJavaClassMember.put(name, i);
            }
            this.fieldMapping = Maps.newHashMap();
            for (i = 0; i < parameters.size(); ++i) {
                Parameter parameter = parameters.get(i);
                String paramName = parameter.getName();
                Integer index = (Integer)fieldsByLogicalName.get(paramName);
                if (index == null) {
                    index = (Integer)fieldsByJavaClassMember.get(paramName);
                }
                if (index == null) {
                    throw new RuntimeException("Creator parameter " + paramName + " Doesn't correspond to a schema field");
                }
                this.fieldMapping.put(i, index);
            }
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation stackManipulation = this.beforePushingParameters();
                ConvertType convertType = new ConvertType(true);
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Parameter parameter = this.parameters.get(i);
                    TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(parameter.getType())));
                    StackManipulation.Compound readParameter = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue(this.fieldMapping.get(i)), ArrayAccess.REFERENCE.load(), TypeCasting.to(convertedType));
                    stackManipulation = new StackManipulation.Compound(stackManipulation, (StackManipulation)new ConvertValueForSetter(readParameter).convert(TypeDescriptor.of(parameter.getType())));
                }
                stackManipulation = new StackManipulation.Compound(stackManipulation, this.afterPushingParameters(), MethodReturn.REFERENCE);
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }

        protected StackManipulation beforePushingParameters() {
            return new StackManipulation.Compound(new StackManipulation[0]);
        }

        protected StackManipulation afterPushingParameters() {
            return new StackManipulation.Compound(new StackManipulation[0]);
        }
    }

    static class StaticFactoryMethodInstruction
    extends InvokeUserCreateInstruction {
        private final Method creator;

        StaticFactoryMethodInstruction(List<FieldValueTypeInformation> fields, Class targetClass, Method creator) {
            super(fields, targetClass, Lists.newArrayList(creator.getParameters()));
            if (!Modifier.isStatic(creator.getModifiers())) {
                throw new IllegalArgumentException("Method " + creator + " is not static");
            }
            this.creator = creator;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        protected StackManipulation afterPushingParameters() {
            return MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(this.creator));
        }
    }

    static class ConstructorCreateInstruction
    extends InvokeUserCreateInstruction {
        private final Constructor constructor;

        ConstructorCreateInstruction(List<FieldValueTypeInformation> fields, Class targetClass, Constructor constructor) {
            super(fields, targetClass, Lists.newArrayList(constructor.getParameters()));
            this.constructor = constructor;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        protected StackManipulation beforePushingParameters() {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(this.targetClass);
            return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE);
        }

        @Override
        protected StackManipulation afterPushingParameters() {
            return MethodInvocation.invoke(new MethodDescription.ForLoadedConstructor(this.constructor));
        }
    }

    static class ConvertValueForSetter
    extends TypeConversion<StackManipulation> {
        StackManipulation readValue;

        ConvertValueForSetter(StackManipulation readValue) {
            this.readValue = readValue;
        }

        @Override
        protected StackManipulation convertArray(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            TypeDescription arrayType = TypeDescription.Generic.Builder.rawType(loadedType.getComponentType().asBoxed()).asArray().build().asErasure();
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.readValue, TypeCasting.to(LIST_TYPE), ArrayFactory.forType(loadedType.getComponentType().asBoxed().asGenericType()).withValues(Collections.emptyList()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)LIST_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toArray").and(ElementMatchers.takesArguments(1)))).getOnly()), TypeCasting.to(arrayType));
            if (loadedType.getComponentType().isPrimitive()) {
                stackManipulation = new StackManipulation.Compound(stackManipulation, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ARRAY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toPrimitive").and(ElementMatchers.takesArguments(arrayType)))).getOnly()));
            }
            return stackManipulation;
        }

        @Override
        protected StackManipulation convertCollection(TypeDescriptor<?> type) {
            return this.readValue;
        }

        @Override
        protected StackManipulation convertMap(TypeDescriptor<?> type) {
            return this.readValue;
        }

        @Override
        protected StackManipulation convertDateTime(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE, this.readValue, TypeCasting.to(READABLE_INSTANT_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)READABLE_INSTANT_TYPE.getDeclaredMethods().filter(ElementMatchers.named("getMillis"))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(TypeDescription.ForLoadedType.of(Long.TYPE))))).getOnly()));
        }

        @Override
        protected StackManipulation convertByteBuffer(TypeDescriptor<?> type) {
            return new StackManipulation.Compound(this.readValue, TypeCasting.to(BYTE_ARRAY_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUFFER_TYPE.getDeclaredMethods().filter(ElementMatchers.named("wrap").and(ElementMatchers.takesArguments(new TypeDescription[]{BYTE_ARRAY_TYPE})))).getOnly()));
        }

        @Override
        protected StackManipulation convertGenericFixed(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE, this.readValue, TypeCasting.to(BYTE_ARRAY_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(new TypeDescription[]{BYTE_ARRAY_TYPE})))).getOnly()));
        }

        @Override
        protected StackManipulation convertCharSequence(TypeDescriptor<?> type) {
            if (type.getRawType().isAssignableFrom(String.class)) {
                return this.readValue;
            }
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE, this.readValue, TypeCasting.to(CHAR_SEQUENCE_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(new TypeDescription[]{CHAR_SEQUENCE_TYPE})))).getOnly()));
        }

        @Override
        protected StackManipulation convertPrimitive(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType valueType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(this.readValue, Assigner.DEFAULT.assign(valueType.asBoxed().asGenericType(), valueType.asUnboxed().asGenericType(), Assigner.Typing.STATIC));
        }

        @Override
        protected StackManipulation convertDefault(TypeDescriptor<?> type) {
            return this.readValue;
        }
    }

    static class ConvertValueForGetter
    extends TypeConversion<StackManipulation> {
        private final StackManipulation readValue;

        ConvertValueForGetter(StackManipulation readValue) {
            this.readValue = readValue;
        }

        @Override
        protected StackManipulation convertArray(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            StackManipulation stackManipulation = this.readValue;
            if (loadedType.getComponentType().isPrimitive()) {
                stackManipulation = new StackManipulation.Compound(stackManipulation, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ARRAY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("toObject")).and(ElementMatchers.takesArguments(new TypeDescription[]{loadedType})))).getOnly()));
            }
            return new StackManipulation.Compound(stackManipulation, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ARRAYS_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("asList")))).getOnly()));
        }

        @Override
        protected StackManipulation convertCollection(TypeDescriptor<?> type) {
            return this.readValue;
        }

        @Override
        protected StackManipulation convertMap(TypeDescriptor<?> type) {
            return this.readValue;
        }

        @Override
        protected StackManipulation convertDateTime(TypeDescriptor<?> type) {
            if (Instant.class.isAssignableFrom(type.getRawType())) {
                return this.readValue;
            }
            return new StackManipulation.Compound(TypeCreation.of(INSTANT_TYPE), Duplication.SINGLE, this.readValue, TypeCasting.to(READABLE_INSTANT_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)READABLE_INSTANT_TYPE.getDeclaredMethods().filter(ElementMatchers.named("getMillis"))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)INSTANT_TYPE.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(TypeDescription.ForLoadedType.of(Long.TYPE))))).getOnly()));
        }

        @Override
        protected StackManipulation convertByteBuffer(TypeDescriptor<?> type) {
            return new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUFFER_TYPE.getDeclaredMethods().filter(ElementMatchers.named("array").and(ElementMatchers.returns(BYTE_ARRAY_TYPE)))).getOnly()));
        }

        @Override
        protected StackManipulation convertGenericFixed(TypeDescriptor<?> type) {
            return new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(GenericFixed.class).getDeclaredMethods().filter(ElementMatchers.named("bytes").and(ElementMatchers.returns(BYTE_ARRAY_TYPE)))).getOnly()));
        }

        @Override
        protected StackManipulation convertCharSequence(TypeDescriptor<?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(String.class))) {
                return this.readValue;
            }
            return new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)CHAR_SEQUENCE_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toString"))).getOnly()));
        }

        @Override
        protected StackManipulation convertPrimitive(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(this.readValue, Assigner.DEFAULT.assign(loadedType.asGenericType(), loadedType.asBoxed().asGenericType(), Assigner.Typing.STATIC));
        }

        @Override
        protected StackManipulation convertDefault(TypeDescriptor<?> type) {
            return this.readValue;
        }
    }

    static class ConvertType
    extends TypeConversion<Type> {
        private boolean returnRawTypes;

        public ConvertType(boolean returnRawTypes) {
            this.returnRawTypes = returnRawTypes;
        }

        @Override
        protected Type convertArray(TypeDescriptor<?> type) {
            TypeDescriptor ret = this.createListType(type);
            return this.returnRawTypes ? ret.getRawType() : ret.getType();
        }

        @Override
        protected Type convertCollection(TypeDescriptor<?> type) {
            return Collection.class;
        }

        @Override
        protected Type convertMap(TypeDescriptor<?> type) {
            return Map.class;
        }

        @Override
        protected Type convertDateTime(TypeDescriptor<?> type) {
            return Instant.class;
        }

        @Override
        protected Type convertByteBuffer(TypeDescriptor<?> type) {
            return byte[].class;
        }

        @Override
        protected Type convertGenericFixed(TypeDescriptor<?> type) {
            return byte[].class;
        }

        @Override
        protected Type convertCharSequence(TypeDescriptor<?> type) {
            return String.class;
        }

        @Override
        protected Type convertPrimitive(TypeDescriptor<?> type) {
            return ClassUtils.primitiveToWrapper(type.getRawType());
        }

        @Override
        protected Type convertDefault(TypeDescriptor<?> type) {
            return this.returnRawTypes ? type.getRawType() : type.getType();
        }

        private <ElementT> TypeDescriptor<List<ElementT>> createListType(TypeDescriptor<?> type) {
            TypeDescriptor<?> componentType = TypeDescriptor.of(ClassUtils.primitiveToWrapper(type.getComponentType().getRawType()));
            return new TypeDescriptor<List<ElementT>>(){}.where(new TypeParameter<ElementT>(){}, componentType);
        }
    }

    static abstract class TypeConversion<T> {
        TypeConversion() {
        }

        public T convert(TypeDescriptor typeDescriptor) {
            if (typeDescriptor.isArray() && !typeDescriptor.getComponentType().getRawType().equals(Byte.TYPE)) {
                return this.convertArray(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
                return this.convertCollection(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Map.class))) {
                return this.convertMap(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(ReadableInstant.class))) {
                return this.convertDateTime(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(ByteBuffer.class))) {
                return this.convertByteBuffer(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                return this.convertGenericFixed(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(CharSequence.class))) {
                return this.convertCharSequence(typeDescriptor);
            }
            if (typeDescriptor.getRawType().isPrimitive()) {
                return this.convertPrimitive(typeDescriptor);
            }
            return this.convertDefault(typeDescriptor);
        }

        protected abstract T convertArray(TypeDescriptor<?> var1);

        protected abstract T convertCollection(TypeDescriptor<?> var1);

        protected abstract T convertMap(TypeDescriptor<?> var1);

        protected abstract T convertDateTime(TypeDescriptor<?> var1);

        protected abstract T convertByteBuffer(TypeDescriptor<?> var1);

        protected abstract T convertGenericFixed(TypeDescriptor<?> var1);

        protected abstract T convertCharSequence(TypeDescriptor<?> var1);

        protected abstract T convertPrimitive(TypeDescriptor<?> var1);

        protected abstract T convertDefault(TypeDescriptor<?> var1);
    }

    static class InjectPackageStrategy
    extends NamingStrategy.AbstractBase {
        private static final NamingStrategy.SuffixingRandom.BaseNameResolver baseNameResolver = NamingStrategy.SuffixingRandom.BaseNameResolver.ForUnnamedType.INSTANCE;
        private static final String SUFFIX = "SchemaCodeGen";
        private final RandomString randomString = new RandomString();
        private final String targetPackage;

        public InjectPackageStrategy(Class<?> baseType) {
            this.targetPackage = baseType.getPackage().getName();
        }

        @Override
        protected String name(TypeDescription superClass) {
            String baseName = baseNameResolver.resolve(superClass);
            int lastDot = baseName.lastIndexOf(46);
            String className = baseName.substring(lastDot, baseName.length());
            return this.targetPackage + className + "$" + SUFFIX + "$" + this.randomString.nextString();
        }
    }
}

