/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.core.net.bytebuddy.ByteBuddy;
import org.apache.beam.repackaged.core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.repackaged.core.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.primitives.Primitives;

public class ConvertHelpers {
    public static <T> ConvertedSchemaInformation<T> getConvertedSchemaInformation(Schema inputSchema, TypeDescriptor<T> outputType, SchemaRegistry schemaRegistry) {
        ConvertedSchemaInformation convertedSchema = null;
        boolean toRow = outputType.equals(TypeDescriptor.of(Row.class));
        if (toRow) {
            convertedSchema = new ConvertedSchemaInformation(SchemaCoder.of(inputSchema, SerializableFunctions.identity(), SerializableFunctions.identity()), null);
        } else {
            Schema outputSchema = null;
            SchemaCoder<T> outputSchemaCoder = null;
            try {
                outputSchema = schemaRegistry.getSchema(outputType);
                outputSchemaCoder = SchemaCoder.of(outputSchema, schemaRegistry.getToRowFunction(outputType), schemaRegistry.getFromRowFunction(outputType));
            }
            catch (NoSuchSchemaException noSuchSchemaException) {
                // empty catch block
            }
            Schema.FieldType unboxedType = null;
            if (outputSchema == null || !outputSchema.assignableToIgnoreNullable(inputSchema)) {
                Schema checkedSchema = inputSchema;
                if (inputSchema.getFieldCount() == 1) {
                    unboxedType = inputSchema.getField(0).getType();
                    checkedSchema = unboxedType.getTypeName().isCompositeType() && !outputSchema.assignableToIgnoreNullable(unboxedType.getRowSchema()) ? unboxedType.getRowSchema() : null;
                }
                if (checkedSchema != null) {
                    throw new RuntimeException("Cannot convert between types that don't have equivalent schemas. input schema: " + checkedSchema + " output schema: " + outputSchema);
                }
            }
            convertedSchema = new ConvertedSchemaInformation<T>(outputSchemaCoder, unboxedType);
        }
        return convertedSchema;
    }

    public static <OutputT> SerializableFunction<?, OutputT> getConvertPrimitive(Schema.FieldType fieldType, TypeDescriptor<?> outputTypeDescriptor) {
        Schema.FieldType expectedFieldType = StaticSchemaInference.fieldFromType(outputTypeDescriptor, JavaFieldSchema.JavaFieldTypeSupplier.INSTANCE);
        if (!expectedFieldType.equals(fieldType)) {
            throw new IllegalArgumentException("Element argument type " + outputTypeDescriptor + " does not work with expected schema field type " + fieldType);
        }
        Type expectedInputType = (Type)new ByteBuddyUtils.ConvertType(true).convert(outputTypeDescriptor);
        TypeDescriptor<?> outputType = outputTypeDescriptor;
        if (outputType.getRawType().isPrimitive()) {
            outputType = TypeDescriptor.of(Primitives.wrap(outputType.getRawType()));
        }
        TypeDescription.Generic genericType = TypeDescription.Generic.Builder.parameterizedType(SerializableFunction.class, expectedInputType, outputType.getType()).build();
        DynamicType.Builder<?> builder = new ByteBuddy().subclass(genericType);
        try {
            return (SerializableFunction)builder.method(ElementMatchers.named("apply")).intercept(new ConvertPrimitiveInstruction(outputType)).make().load(ReflectHelpers.findClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static class ConvertPrimitiveInstruction
    implements Implementation {
        private final TypeDescriptor<?> outputFieldType;

        public ConvertPrimitiveInstruction(TypeDescriptor<?> outputFieldType) {
            this.outputFieldType = outputFieldType;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation readValue = MethodVariableAccess.REFERENCE.loadFrom(1);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound((StackManipulation)new ByteBuddyUtils.ConvertValueForSetter(readValue).convert(this.outputFieldType), MethodReturn.REFERENCE);
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    public static class ConvertedSchemaInformation<T>
    implements Serializable {
        @Nullable
        public final SchemaCoder<T> outputSchemaCoder;
        @Nullable
        public final Schema.FieldType unboxedType;

        public ConvertedSchemaInformation(@Nullable SchemaCoder<T> outputSchemaCoder, @Nullable Schema.FieldType unboxedType) {
            assert (outputSchemaCoder != null || unboxedType != null);
            this.outputSchemaCoder = outputSchemaCoder;
            this.unboxedType = unboxedType;
        }
    }
}

