/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.net.bytebuddy.ByteBuddy;
import org.apache.beam.repackaged.core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.FixedValue;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.Removal;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.repackaged.core.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class JavaBeanUtils {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueTypeInformation>> CACHED_FIELD_TYPES = Maps.newConcurrentMap();
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueGetter>> CACHED_GETTERS = Maps.newConcurrentMap();
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueSetter>> CACHED_SETTERS = Maps.newConcurrentMap();
    public static final Map<ReflectUtils.ClassWithSchema, SchemaUserTypeCreator> CACHED_CREATORS = Maps.newConcurrentMap();

    public static Schema schemaFromJavaBeanClass(Class<?> clazz, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return StaticSchemaInference.schemaFromClass(clazz, fieldValueTypeSupplier);
    }

    public static void validateJavaBean(List<FieldValueTypeInformation> getters, List<FieldValueTypeInformation> setters) {
        Map setterMap = setters.stream().collect(Collectors.toMap(FieldValueTypeInformation::getName, Function.identity()));
        for (FieldValueTypeInformation type : getters) {
            FieldValueTypeInformation setterType = (FieldValueTypeInformation)setterMap.get(type.getName());
            if (setterType == null) {
                throw new RuntimeException("JavaBean contained a getter for field " + type.getName() + "but did not contain a matching setter.");
            }
            if (!type.getType().equals(setterType.getType())) {
                throw new RuntimeException("JavaBean contained setter for field " + type.getName() + " that had a mismatching type.");
            }
            if (!type.isNullable() != setterType.isNullable()) continue;
            throw new RuntimeException("JavaBean contained setter for field " + type.getName() + " that had a mismatching nullable attribute.");
        }
    }

    public static List<FieldValueTypeInformation> getFieldTypes(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_FIELD_TYPES.computeIfAbsent(new ReflectUtils.ClassWithSchema(clazz, schema), c -> fieldValueTypeSupplier.get(clazz, schema));
    }

    public static List<FieldValueGetter> getGetters(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_GETTERS.computeIfAbsent(new ReflectUtils.ClassWithSchema(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return types.stream().map(JavaBeanUtils::createGetter).collect(Collectors.toList());
        });
    }

    private static <T> FieldValueGetter createGetter(FieldValueTypeInformation typeInformation) {
        DynamicType.Builder<FieldValueGetter> builder = ByteBuddyUtils.subclassGetterInterface(BYTE_BUDDY, typeInformation.getMethod().getDeclaringClass(), (Type)new ByteBuddyUtils.ConvertType(false).convert(typeInformation.getType()));
        builder = JavaBeanUtils.implementGetterMethods(builder, typeInformation);
        try {
            return builder.make().load(ReflectHelpers.findClassLoader(typeInformation.getMethod().getDeclaringClass().getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a getter for getter '" + typeInformation.getMethod() + "'");
        }
    }

    private static DynamicType.Builder<FieldValueGetter> implementGetterMethods(DynamicType.Builder<FieldValueGetter> builder, FieldValueTypeInformation typeInformation) {
        return builder.method(ElementMatchers.named("name")).intercept(FixedValue.reference(typeInformation.getName())).method(ElementMatchers.named("get")).intercept(new InvokeGetterInstruction(typeInformation));
    }

    public static List<FieldValueSetter> getSetters(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_SETTERS.computeIfAbsent(new ReflectUtils.ClassWithSchema(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return types.stream().map(JavaBeanUtils::createSetter).collect(Collectors.toList());
        });
    }

    private static FieldValueSetter createSetter(FieldValueTypeInformation typeInformation) {
        DynamicType.Builder<FieldValueSetter> builder = ByteBuddyUtils.subclassSetterInterface(BYTE_BUDDY, typeInformation.getMethod().getDeclaringClass(), (Type)new ByteBuddyUtils.ConvertType(false).convert(typeInformation.getType()));
        builder = JavaBeanUtils.implementSetterMethods(builder, typeInformation.getMethod());
        try {
            return builder.make().load(ReflectHelpers.findClassLoader(typeInformation.getMethod().getDeclaringClass().getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a setter for setter '" + typeInformation.getMethod() + "'");
        }
    }

    private static DynamicType.Builder<FieldValueSetter> implementSetterMethods(DynamicType.Builder<FieldValueSetter> builder, Method method) {
        FieldValueTypeInformation javaTypeInformation = FieldValueTypeInformation.forSetter(method);
        return builder.method(ElementMatchers.named("name")).intercept(FixedValue.reference(javaTypeInformation.getName())).method(ElementMatchers.named("set")).intercept(new InvokeSetterInstruction(method));
    }

    public static SchemaUserTypeCreator getConstructorCreator(Class clazz, Constructor constructor, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_CREATORS.computeIfAbsent(new ReflectUtils.ClassWithSchema(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return JavaBeanUtils.createConstructorCreator(clazz, constructor, schema, types);
        });
    }

    public static <T> SchemaUserTypeCreator createConstructorCreator(Class<T> clazz, Constructor<T> constructor, Schema schema, List<FieldValueTypeInformation> types) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition<SchemaUserTypeCreator> builder = BYTE_BUDDY.with(new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method(ElementMatchers.named("create")).intercept(new ByteBuddyUtils.ConstructorCreateInstruction(types, clazz, constructor));
            return (SchemaUserTypeCreator)builder.make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for class " + clazz + " with schema " + schema);
        }
    }

    public static SchemaUserTypeCreator getStaticCreator(Class clazz, Method creator, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_CREATORS.computeIfAbsent(new ReflectUtils.ClassWithSchema(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return JavaBeanUtils.createStaticCreator(clazz, creator, schema, types);
        });
    }

    public static <T> SchemaUserTypeCreator createStaticCreator(Class<T> clazz, Method creator, Schema schema, List<FieldValueTypeInformation> types) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition<SchemaUserTypeCreator> builder = BYTE_BUDDY.with(new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method(ElementMatchers.named("create")).intercept(new ByteBuddyUtils.StaticFactoryMethodInstruction(types, clazz, creator));
            return (SchemaUserTypeCreator)builder.make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for " + clazz + " with schema " + schema);
        }
    }

    private static class InvokeSetterInstruction
    implements Implementation {
        private Method method;

        InvokeSetterInstruction(Method method) {
            this.method = method;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                FieldValueTypeInformation javaTypeInformation = FieldValueTypeInformation.forSetter(this.method);
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation readField = MethodVariableAccess.REFERENCE.loadFrom(2);
                boolean setterMethodReturnsVoid = this.method.getReturnType().equals(Void.TYPE);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), (StackManipulation)new ByteBuddyUtils.ConvertValueForSetter(readField).convert(javaTypeInformation.getType()), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(this.method)));
                if (!setterMethodReturnsVoid) {
                    stackManipulation = new StackManipulation.Compound(stackManipulation, Removal.SINGLE);
                }
                stackManipulation = new StackManipulation.Compound(stackManipulation, MethodReturn.VOID);
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    private static class InvokeGetterInstruction
    implements Implementation {
        private final FieldValueTypeInformation typeInformation;

        InvokeGetterInstruction(FieldValueTypeInformation typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound readValue = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(this.typeInformation.getMethod())));
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound((StackManipulation)new ByteBuddyUtils.ConvertValueForGetter(readValue).convert(this.typeInformation.getType()), MethodReturn.REFERENCE);
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }
}

