/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public class ReflectUtils {
    private static final Map<Class, List<Method>> DECLARED_METHODS = Maps.newHashMap();
    private static final Map<Class, Method> ANNOTATED_CONSTRUCTORS = Maps.newHashMap();
    private static final Map<Class, List<Field>> DECLARED_FIELDS = Maps.newHashMap();

    public static List<Method> getMethods(Class clazz) {
        return DECLARED_METHODS.computeIfAbsent(clazz, c -> Arrays.stream(c.getDeclaredMethods()).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> !Modifier.isStatic(m.getModifiers())).collect(Collectors.toList()));
    }

    @Nullable
    public static Constructor getAnnotatedConstructor(Class clazz) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> m.getAnnotation(SchemaCreate.class) != null).findFirst().orElse(null);
    }

    @Nullable
    public static Method getAnnotatedCreateMethod(Class clazz) {
        return ANNOTATED_CONSTRUCTORS.computeIfAbsent(clazz, c -> {
            Method method = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getAnnotation(SchemaCreate.class) != null).findFirst().orElse(null);
            if (method != null && !clazz.isAssignableFrom(method.getReturnType())) {
                throw new InvalidParameterException("A method marked with SchemaCreate in class " + clazz + " does not return a type assignable to " + clazz);
            }
            return method;
        });
    }

    public static List<Field> getFields(Class<?> clazz) {
        return DECLARED_FIELDS.computeIfAbsent(clazz, c -> {
            LinkedHashMap<String, Field> types = new LinkedHashMap<String, Field>();
            while (c.getPackage() == null || !c.getPackage().getName().startsWith("java.")) {
                for (Field field : c.getDeclaredFields()) {
                    if ((field.getModifiers() & 0x88) != 0 || (field.getModifiers() & 6) != 0) continue;
                    Preconditions.checkArgument(types.put(field.getName(), field) == null, c.getSimpleName() + " contains two fields named: " + field);
                }
                if ((c = c.getSuperclass()) != null) continue;
            }
            return Lists.newArrayList(types.values());
        });
    }

    public static boolean isGetter(Method method) {
        if (Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        if (method.getName().startsWith("get") && method.getName().length() > 3) {
            return true;
        }
        return method.getName().startsWith("is") && method.getName().length() > 2 && method.getParameterCount() == 0 && (Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType()));
    }

    public static boolean isSetter(Method method) {
        return method.getParameterCount() == 1 && method.getName().startsWith("set");
    }

    public static String stripPrefix(String methodName, String prefix) {
        if (!methodName.startsWith(prefix)) {
            return methodName;
        }
        String firstLetter = methodName.substring(prefix.length(), prefix.length() + 1).toLowerCase();
        return methodName.length() == prefix.length() + 1 ? firstLetter : firstLetter + methodName.substring(prefix.length() + 1, methodName.length());
    }

    public static String stripGetterPrefix(String method) {
        if (method.startsWith("get")) {
            return ReflectUtils.stripPrefix(method, "get");
        }
        return ReflectUtils.stripPrefix(method, "is");
    }

    public static String stripSetterPrefix(String method) {
        return ReflectUtils.stripPrefix(method, "set");
    }

    static class ClassWithSchema {
        private final Class clazz;
        private final Schema schema;

        ClassWithSchema(Class clazz, Schema schema) {
            this.clazz = clazz;
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassWithSchema that = (ClassWithSchema)o;
            return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.schema);
        }
    }
}

