/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.AutoValue_SchemaZipFold_Context;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;

public abstract class SchemaZipFold<T>
implements Serializable {
    public final T apply(Schema left, Schema right) {
        return SchemaZipFold.visit(this, Context.EMPTY, Schema.FieldType.row(left), Schema.FieldType.row(right));
    }

    public abstract T accumulate(T var1, T var2);

    public abstract T accept(Context var1, Schema.FieldType var2, Schema.FieldType var3);

    public abstract T accept(Context var1, Optional<Schema.Field> var2, Optional<Schema.Field> var3);

    static <T> T visit(SchemaZipFold<T> zipFold, Context context, Schema.FieldType left, Schema.FieldType right) {
        if (left.getTypeName() != right.getTypeName()) {
            return zipFold.accept(context, left, right);
        }
        Context newContext = context.withParent(left.getTypeName());
        switch (left.getTypeName()) {
            case ARRAY: {
                return zipFold.accumulate(zipFold.accept(context, left, right), SchemaZipFold.visit(zipFold, newContext, left.getCollectionElementType(), right.getCollectionElementType()));
            }
            case ROW: {
                return SchemaZipFold.visitRow(zipFold, newContext, left.getRowSchema(), right.getRowSchema());
            }
            case MAP: {
                return zipFold.accumulate(zipFold.accept(context, left, right), SchemaZipFold.visit(zipFold, newContext, left.getCollectionElementType(), right.getCollectionElementType()));
            }
        }
        return zipFold.accept(context, left, right);
    }

    static <T> T visitRow(SchemaZipFold<T> zipFold, Context context, Schema left, Schema right) {
        T node = zipFold.accept(context, Schema.FieldType.row(left), Schema.FieldType.row(right));
        Stream<String> union = Stream.concat(left.getFields().stream().map(Schema.Field::getName), right.getFields().stream().map(Schema.Field::getName)).distinct();
        Stream<String> intersection = left.getFields().stream().map(Schema.Field::getName).filter(right::hasField);
        Object inner0 = intersection.map(name -> SchemaZipFold.visit(zipFold, context.withPathPart((String)name).withParent(Schema.TypeName.ROW), left.getField((String)name).getType(), right.getField((String)name).getType())).reduce(node, zipFold::accumulate);
        Object inner1 = union.map(name -> {
            Optional<Schema.Field> field0 = Optional.empty();
            Optional<Schema.Field> field1 = Optional.empty();
            if (left.hasField((String)name)) {
                field0 = Optional.of(left.getField((String)name));
            }
            if (right.hasField((String)name)) {
                field1 = Optional.of(right.getField((String)name));
            }
            Context newContext = context.withPathPart((String)name).withParent(Schema.TypeName.ROW);
            return zipFold.accept(newContext, field0, field1);
        }).reduce(node, zipFold::accumulate);
        return (T)zipFold.accumulate(zipFold.accumulate(node, inner0), inner1);
    }

    @AutoValue
    public static abstract class Context {
        public static final Context EMPTY = Context.create(Collections.emptyList(), Optional.empty());

        public abstract List<String> path();

        public abstract Optional<Schema.TypeName> parent();

        public Context withPathPart(String part) {
            return Context.create((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.path())).add(part)).build()), this.parent());
        }

        public Context withParent(Schema.TypeName parent) {
            return Context.create(this.path(), Optional.of(parent));
        }

        public static Context create(List<String> path, Optional<Schema.TypeName> parent) {
            return new AutoValue_SchemaZipFold_Context(path, parent);
        }
    }
}

