/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public class SelectHelpers {
    private static Schema union(Iterable<Schema> schemas) {
        Schema.Builder unioned = Schema.builder();
        for (Schema schema : schemas) {
            unioned.addFields(schema.getFields());
        }
        return unioned.build();
    }

    public static Schema getOutputSchema(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor) {
        if (fieldAccessDescriptor.getAllFields()) {
            return inputSchema;
        }
        ArrayList<Schema> schemas = Lists.newArrayList();
        Schema.Builder builder = Schema.builder();
        Iterator<Object> iterator = fieldAccessDescriptor.fieldIdsAccessed().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            builder.addField(inputSchema.getField(n));
        }
        schemas.add(builder.build());
        for (Map.Entry entry : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
            FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)entry.getKey();
            FieldAccessDescriptor nestedAccess = (FieldAccessDescriptor)entry.getValue();
            Schema.Field field = inputSchema.getField(Preconditions.checkNotNull(fieldDescriptor.getFieldId()));
            Schema outputSchema = SelectHelpers.getOutputSchemaHelper(field.getType(), nestedAccess, fieldDescriptor.getQualifiers(), 0);
            schemas.add(outputSchema);
        }
        return SelectHelpers.union(schemas);
    }

    private static Schema getOutputSchemaHelper(Schema.FieldType inputFieldType, FieldAccessDescriptor fieldAccessDescriptor, List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, int qualifierPosition) {
        if (qualifierPosition >= qualifiers.size()) {
            Preconditions.checkArgument(inputFieldType.getTypeName().isCompositeType());
            return SelectHelpers.getOutputSchema(inputFieldType.getRowSchema(), fieldAccessDescriptor);
        }
        FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier = qualifiers.get(qualifierPosition);
        Schema.Builder builder = Schema.builder();
        switch (qualifier.getKind()) {
            case LIST: {
                Preconditions.checkArgument(qualifier.getList().equals((Object)FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
                Schema.FieldType componentType = Preconditions.checkNotNull(inputFieldType.getCollectionElementType());
                Schema outputComponent = SelectHelpers.getOutputSchemaHelper(componentType, fieldAccessDescriptor, qualifiers, qualifierPosition + 1);
                for (Schema.Field field : outputComponent.getFields()) {
                    Schema.Field newField = Schema.Field.of(field.getName(), Schema.FieldType.array(field.getType())).withNullable(inputFieldType.getNullable());
                    builder.addField(newField);
                }
                return builder.build();
            }
            case MAP: {
                Preconditions.checkArgument(qualifier.getMap().equals((Object)FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
                Schema.FieldType keyType = Preconditions.checkNotNull(inputFieldType.getMapKeyType());
                Schema.FieldType valueType = Preconditions.checkNotNull(inputFieldType.getMapValueType());
                Schema outputValueSchema = SelectHelpers.getOutputSchemaHelper(valueType, fieldAccessDescriptor, qualifiers, qualifierPosition + 1);
                for (Schema.Field field : outputValueSchema.getFields()) {
                    Schema.Field newField = Schema.Field.of(field.getName(), Schema.FieldType.map(keyType, field.getType())).withNullable(inputFieldType.getNullable());
                    builder.addField(newField);
                }
                return builder.build();
            }
        }
        throw new RuntimeException("unexpected");
    }

    public static Row selectRow(Row input, FieldAccessDescriptor fieldAccessDescriptor, Schema inputSchema, Schema outputSchema) {
        if (fieldAccessDescriptor.getAllFields()) {
            return input;
        }
        Row.Builder output = Row.withSchema(outputSchema);
        SelectHelpers.selectIntoRow(input, output, fieldAccessDescriptor);
        return output.build();
    }

    public static void selectIntoRow(Row input, Row.Builder output, FieldAccessDescriptor fieldAccessDescriptor) {
        if (fieldAccessDescriptor.getAllFields()) {
            output.addValues(input.getValues());
            return;
        }
        for (int fieldId : fieldAccessDescriptor.fieldIdsAccessed()) {
            output.addValue(input.getValue(fieldId));
        }
        Schema outputSchema = output.getSchema();
        for (Map.Entry<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nested : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
            FieldAccessDescriptor.FieldDescriptor field = nested.getKey();
            FieldAccessDescriptor nestedAccess = nested.getValue();
            Schema.FieldType nestedInputType = input.getSchema().getField(field.getFieldId()).getType();
            Schema.FieldType nestedOutputType = outputSchema.getField(output.nextFieldId()).getType();
            SelectHelpers.selectIntoRowHelper(field.getQualifiers(), input.getValue(field.getFieldId()), output, nestedAccess, nestedInputType, nestedOutputType);
        }
    }

    private static void selectIntoRowHelper(List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, Object value, Row.Builder output, FieldAccessDescriptor fieldAccessDescriptor, Schema.FieldType inputType, Schema.FieldType outputType) {
        if (qualifiers.isEmpty()) {
            Row row = (Row)value;
            SelectHelpers.selectIntoRow(row, output, fieldAccessDescriptor);
            return;
        }
        SelectHelpers.selectIntoRowWithQualifiers(qualifiers, 0, value, output, fieldAccessDescriptor, inputType, outputType);
    }

    private static void selectIntoRowWithQualifiers(List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, int qualifierPosition, Object value, Row.Builder output, FieldAccessDescriptor fieldAccessDescriptor, Schema.FieldType inputType, Schema.FieldType outputType) {
        if (qualifierPosition >= qualifiers.size()) {
            Row row = (Row)value;
            SelectHelpers.selectIntoRow(row, output, fieldAccessDescriptor);
            return;
        }
        FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier = qualifiers.get(qualifierPosition);
        switch (qualifier.getKind()) {
            case LIST: {
                Schema.FieldType nestedInputType = Preconditions.checkNotNull(inputType.getCollectionElementType());
                Schema.FieldType nestedOutputType = Preconditions.checkNotNull(outputType.getCollectionElementType());
                List list = (List)value;
                Schema tempSchema = Schema.builder().addField("a", nestedInputType).build();
                FieldAccessDescriptor tempAccessDescriptor = FieldAccessDescriptor.create().withNestedField("a", fieldAccessDescriptor).resolve(tempSchema);
                Schema nestedSchema = SelectHelpers.getOutputSchema(tempSchema, tempAccessDescriptor);
                ArrayList selectedLists = Lists.newArrayListWithCapacity(nestedSchema.getFieldCount());
                for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                    selectedLists.add(Lists.newArrayListWithCapacity(list.size()));
                }
                for (Object e : list) {
                    Row.Builder selectElementBuilder = Row.withSchema(nestedSchema);
                    SelectHelpers.selectIntoRowWithQualifiers(qualifiers, qualifierPosition + 1, e, selectElementBuilder, fieldAccessDescriptor, nestedInputType, nestedOutputType);
                    Row elementBeforeDistribution = selectElementBuilder.build();
                    for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                        ((List)selectedLists.get(i)).add(elementBeforeDistribution.getValue(i));
                    }
                }
                for (List list2 : selectedLists) {
                    output.addValue(list2);
                }
                break;
            }
            case MAP: {
                Schema.FieldType nestedInputType = Preconditions.checkNotNull(inputType.getMapValueType());
                Schema.FieldType nestedOutputType = Preconditions.checkNotNull(outputType.getMapValueType());
                Schema tempSchema = Schema.builder().addField("a", nestedInputType).build();
                FieldAccessDescriptor tempAccessDescriptor = FieldAccessDescriptor.create().withNestedField("a", fieldAccessDescriptor).resolve(tempSchema);
                Schema nestedSchema = SelectHelpers.getOutputSchema(tempSchema, tempAccessDescriptor);
                ArrayList selectedMaps = Lists.newArrayListWithExpectedSize(nestedSchema.getFieldCount());
                for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                    selectedMaps.add(Maps.newHashMap());
                }
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Row.Builder selectValueBuilder = Row.withSchema(nestedSchema);
                    SelectHelpers.selectIntoRowWithQualifiers(qualifiers, qualifierPosition + 1, entry.getValue(), selectValueBuilder, fieldAccessDescriptor, nestedInputType, nestedOutputType);
                    Row valueBeforeDistribution = selectValueBuilder.build();
                    for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                        ((Map)selectedMaps.get(i)).put(entry.getKey(), valueBeforeDistribution.getValue(i));
                    }
                }
                for (Map map2 : selectedMaps) {
                    output.addValue(map2);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected type " + (Object)((Object)qualifier.getKind()));
            }
        }
    }
}

