/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.joda.time.ReadableInstant;

public class StaticSchemaInference {
    private static final Map<Class, Schema.FieldType> PRIMITIVE_TYPES = ImmutableMap.builder().put(Byte.class, Schema.FieldType.BYTE).put(Byte.TYPE, Schema.FieldType.BYTE).put(Short.class, Schema.FieldType.INT16).put(Short.TYPE, Schema.FieldType.INT16).put(Integer.class, Schema.FieldType.INT32).put(Integer.TYPE, Schema.FieldType.INT32).put(Long.class, Schema.FieldType.INT64).put(Long.TYPE, Schema.FieldType.INT64).put(Float.class, Schema.FieldType.FLOAT).put(Float.TYPE, Schema.FieldType.FLOAT).put(Double.class, Schema.FieldType.DOUBLE).put(Double.TYPE, Schema.FieldType.DOUBLE).put(Boolean.class, Schema.FieldType.BOOLEAN).put(Boolean.TYPE, Schema.FieldType.BOOLEAN).put(BigDecimal.class, Schema.FieldType.DECIMAL).build();

    public static List<FieldValueTypeInformation> sortBySchema(List<FieldValueTypeInformation> types, Schema schema) {
        Map typeMap = types.stream().collect(Collectors.toMap(FieldValueTypeInformation::getName, Function.identity()));
        return schema.getFields().stream().map(f -> (FieldValueTypeInformation)typeMap.get(f.getName())).collect(Collectors.toList());
    }

    public static Schema schemaFromClass(Class<?> clazz, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Schema.Builder builder = Schema.builder();
        for (FieldValueTypeInformation type : fieldValueTypeSupplier.get(clazz)) {
            Schema.FieldType fieldType = StaticSchemaInference.fieldFromType(type.getType(), fieldValueTypeSupplier);
            if (type.isNullable()) {
                builder.addNullableField(type.getName(), fieldType);
                continue;
            }
            builder.addField(type.getName(), fieldType);
        }
        return builder.build();
    }

    public static Schema.FieldType fieldFromType(TypeDescriptor type, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Schema.FieldType primitiveType = PRIMITIVE_TYPES.get(type.getRawType());
        if (primitiveType != null) {
            return primitiveType;
        }
        if (type.isArray()) {
            TypeDescriptor<?> component = type.getComponentType();
            if (component.getRawType().equals(Byte.TYPE)) {
                return Schema.FieldType.BYTES;
            }
            return Schema.FieldType.array(StaticSchemaInference.fieldFromType(component, fieldValueTypeSupplier));
        }
        if (type.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
            TypeDescriptor<Collection> collection = type.getSupertype(Collection.class);
            if (collection.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)collection.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument(params.length == 1);
                return Schema.FieldType.array(StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier));
            }
            throw new RuntimeException("Cannot infer schema from unparameterized collection.");
        }
        if (type.isSubtypeOf(TypeDescriptor.of(Map.class))) {
            TypeDescriptor<Map> map = type.getSupertype(Map.class);
            if (map.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)map.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument(params.length == 2);
                Schema.FieldType keyType = StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier);
                Schema.FieldType valueType = StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[1]), fieldValueTypeSupplier);
                Preconditions.checkArgument(keyType.getTypeName().isPrimitiveType(), "Only primitive types can be map keys. type: " + (Object)((Object)keyType.getTypeName()));
                return Schema.FieldType.map(keyType, valueType);
            }
            throw new RuntimeException("Cannot infer schema from unparameterized map.");
        }
        if (type.isSubtypeOf(TypeDescriptor.of(CharSequence.class))) {
            return Schema.FieldType.STRING;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(ReadableInstant.class))) {
            return Schema.FieldType.DATETIME;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(ByteBuffer.class))) {
            return Schema.FieldType.BYTES;
        }
        return Schema.FieldType.row(StaticSchemaInference.schemaFromClass(type.getRawType(), fieldValueTypeSupplier));
    }

    static enum MethodType {
        GETTER,
        SETTER;

    }
}

