/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.util.SerializableThrowable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Objects;

@DefaultCoder(value=SerializableCoder.class)
public final class SuccessOrFailure
implements Serializable {
    private final boolean isSuccess;
    @Nullable
    private final PAssert.PAssertionSite site;
    @Nullable
    private final SerializableThrowable throwable;

    private SuccessOrFailure(boolean isSuccess, @Nullable PAssert.PAssertionSite site, @Nullable Throwable throwable) {
        this.isSuccess = isSuccess;
        this.site = site;
        this.throwable = new SerializableThrowable(throwable);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Nullable
    public AssertionError assertionError() {
        return this.site == null ? null : this.site.wrap(this.throwable.getThrowable());
    }

    public static SuccessOrFailure success() {
        return new SuccessOrFailure(true, null, null);
    }

    public static SuccessOrFailure failure(@Nullable PAssert.PAssertionSite site, @Nullable Throwable t) {
        return new SuccessOrFailure(false, site, t);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("isSuccess", this.isSuccess()).addValue(this.throwable).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuccessOrFailure that = (SuccessOrFailure)o;
        return this.isSuccess == that.isSuccess && Objects.equal(this.site, that.site) && Objects.equal(this.throwable, that.throwable);
    }

    public int hashCode() {
        return Objects.hashCode(this.isSuccess, this.site, this.throwable);
    }
}

