/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.JsonToRowUtils;
import org.apache.beam.sdk.util.RowJsonDeserializer;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

@Experimental
public class JsonToRow {
    public static PTransform<PCollection<? extends String>, PCollection<Row>> withSchema(Schema rowSchema) {
        return JsonToRowFn.forSchema(rowSchema);
    }

    static class JsonToRowFn
    extends PTransform<PCollection<? extends String>, PCollection<Row>> {
        @Nullable
        private volatile transient ObjectMapper objectMapper;
        private Schema schema;

        static JsonToRowFn forSchema(Schema rowSchema) {
            return new JsonToRowFn(rowSchema);
        }

        private JsonToRowFn(Schema schema) {
            this.schema = schema;
        }

        @Override
        public PCollection<Row> expand(PCollection<? extends String> jsonStrings) {
            return ((PCollection)((Object)jsonStrings.apply(ParDo.of(new DoFn<String, Row>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    context.output(JsonToRowUtils.jsonToRow(this.objectMapper(), (String)context.element()));
                }
            })))).setRowSchema(this.schema);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectMapper objectMapper() {
            if (this.objectMapper == null) {
                JsonToRowFn jsonToRowFn = this;
                synchronized (jsonToRowFn) {
                    if (this.objectMapper == null) {
                        this.objectMapper = JsonToRowUtils.newObjectMapperWith(RowJsonDeserializer.forSchema(this.schema));
                    }
                }
            }
            return this.objectMapper;
        }
    }
}

