/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.Materialization;

@Internal
public class Materializations {
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static final String ITERABLE_MATERIALIZATION_URN = RunnerApi.StandardSideInputTypes.Enum.ITERABLE.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static final String MULTIMAP_MATERIALIZATION_URN = RunnerApi.StandardSideInputTypes.Enum.MULTIMAP.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);

    @Internal
    public static <K, V> Materialization<MultimapView<K, V>> multimap() {
        return new Materialization<MultimapView<K, V>>(){

            @Override
            public String getUrn() {
                return MULTIMAP_MATERIALIZATION_URN;
            }
        };
    }

    @Internal
    public static <V> Materialization<IterableView<V>> iterable() {
        return new Materialization<IterableView<V>>(){

            @Override
            public String getUrn() {
                return ITERABLE_MATERIALIZATION_URN;
            }
        };
    }

    public static interface MultimapView<K, V> {
        public Iterable<V> get(@Nullable K var1);
    }

    public static interface IterableView<V> {
        public Iterable<V> get();
    }
}

