/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public abstract class PTransform<InputT extends PInput, OutputT extends POutput>
implements Serializable,
HasDisplayData {
    @Nullable
    protected final transient String name;

    public abstract OutputT expand(InputT var1);

    public void validate(@Nullable PipelineOptions options) {
    }

    public Map<TupleTag<?>, PValue> getAdditionalInputs() {
        return Collections.emptyMap();
    }

    public String getName() {
        return this.name != null ? this.name : this.getKindString();
    }

    protected PTransform() {
        this.name = null;
    }

    protected PTransform(@Nullable String name) {
        this.name = name;
    }

    public String toString() {
        if (this.name == null) {
            return this.getKindString();
        }
        return this.getName() + " [" + this.getKindString() + "]";
    }

    protected String getKindString() {
        if (this.getClass().isAnonymousClass()) {
            return "AnonymousTransform";
        }
        return NameUtils.approximatePTransformName(this.getClass());
    }

    private void writeObject(ObjectOutputStream oos) {
    }

    private void readObject(ObjectInputStream oos) {
    }

    @Deprecated
    protected Coder<?> getDefaultOutputCoder() throws CannotProvideCoderException {
        throw new CannotProvideCoderException("PTransform.getOutputCoder called.");
    }

    @Deprecated
    protected Coder<?> getDefaultOutputCoder(InputT input) throws CannotProvideCoderException {
        return this.getDefaultOutputCoder();
    }

    @Deprecated
    public <T> Coder<T> getDefaultOutputCoder(InputT input, PCollection<T> output) throws CannotProvideCoderException {
        Coder<?> defaultOutputCoder = this.getDefaultOutputCoder(input);
        return defaultOutputCoder;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
    }

    @Experimental
    public static <InputT extends PInput, OutputT extends POutput> PTransform<InputT, OutputT> compose(final SerializableFunction<InputT, OutputT> fn) {
        return new PTransform<InputT, OutputT>(){

            @Override
            public OutputT expand(InputT input) {
                return (POutput)fn.apply(input);
            }
        };
    }

    @Experimental
    public static <InputT extends PInput, OutputT extends POutput> PTransform<InputT, OutputT> compose(String name, final SerializableFunction<InputT, OutputT> fn) {
        return new PTransform<InputT, OutputT>(name){

            @Override
            public OutputT expand(InputT input) {
                return (POutput)fn.apply(input);
            }
        };
    }
}

