/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.TypeDescriptor;

public abstract class SimpleFunction<InputT, OutputT>
extends InferableFunction<InputT, OutputT>
implements SerializableFunction<InputT, OutputT> {
    @Nullable
    private final SerializableFunction<InputT, OutputT> fn;

    protected SimpleFunction() {
        this.fn = null;
        try {
            Method methodThatMustBeOverridden = SimpleFunction.class.getDeclaredMethod("apply", Object.class);
            Method methodOnSubclass = this.getClass().getMethod("apply", Object.class);
            if (methodOnSubclass.equals(methodThatMustBeOverridden)) {
                throw new IllegalStateException("Subclass of SimpleFunction must override 'apply' method or pass a SerializableFunction to the constructor, usually via a lambda or method reference.");
            }
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException("Impossible state: missing 'apply' method entirely", exc);
        }
    }

    protected SimpleFunction(SerializableFunction<InputT, OutputT> fn) {
        this.fn = fn;
    }

    @Override
    public OutputT apply(InputT input) {
        return this.fn.apply(input);
    }

    public static <InputT, OutputT> SimpleFunction<InputT, OutputT> fromSerializableFunctionWithOutputType(SerializableFunction<InputT, OutputT> fn, TypeDescriptor<OutputT> outputType) {
        return new SimpleFunctionWithOutputType<InputT, OutputT>(fn, outputType);
    }

    private static class SimpleFunctionWithOutputType<InputT, OutputT>
    extends SimpleFunction<InputT, OutputT> {
        private final TypeDescriptor<OutputT> outputType;

        public SimpleFunctionWithOutputType(SerializableFunction<InputT, OutputT> fn, TypeDescriptor<OutputT> outputType) {
            super(fn);
            this.outputType = outputType;
        }

        @Override
        public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.outputType;
        }
    }
}

