/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

public class Top {
    private Top() {
    }

    public static <T, ComparatorT extends Comparator<T> & Serializable> Combine.Globally<T, List<T>> of(int count, ComparatorT compareFn) {
        return Combine.globally(new TopCombineFn(count, compareFn));
    }

    public static <T extends Comparable<T>> Combine.Globally<T, List<T>> smallest(int count) {
        return Combine.globally(new TopCombineFn(count, new Reversed()));
    }

    public static <T extends Comparable<T>> Combine.Globally<T, List<T>> largest(int count) {
        return Combine.globally(Top.largestFn(count));
    }

    public static <T extends Comparable<T>> TopCombineFn<T, Natural<T>> largestFn(int count) {
        return new TopCombineFn<T, Natural<T>>(count, new Natural()){};
    }

    public static TopCombineFn<Long, Natural<Long>> largestLongsFn(int count) {
        return new TopCombineFn<Long, Natural<Long>>(count, new Natural()){};
    }

    public static TopCombineFn<Integer, Natural<Integer>> largestIntsFn(int count) {
        return new TopCombineFn<Integer, Natural<Integer>>(count, new Natural()){};
    }

    public static TopCombineFn<Double, Natural<Double>> largestDoublesFn(int count) {
        return new TopCombineFn<Double, Natural<Double>>(count, new Natural()){};
    }

    public static <T extends Comparable<T>> TopCombineFn<T, Reversed<T>> smallestFn(int count) {
        return new TopCombineFn<T, Reversed<T>>(count, new Reversed()){};
    }

    public static TopCombineFn<Long, Reversed<Long>> smallestLongsFn(int count) {
        return new TopCombineFn<Long, Reversed<Long>>(count, new Reversed()){};
    }

    public static TopCombineFn<Integer, Reversed<Integer>> smallestIntsFn(int count) {
        return new TopCombineFn<Integer, Reversed<Integer>>(count, new Reversed()){};
    }

    public static TopCombineFn<Double, Reversed<Double>> smallestDoublesFn(int count) {
        return new TopCombineFn<Double, Reversed<Double>>(count, new Reversed()){};
    }

    public static <K, V, ComparatorT extends Comparator<V> & Serializable> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, List<V>>>> perKey(int count, ComparatorT compareFn) {
        return Combine.perKey(new TopCombineFn(count, compareFn));
    }

    public static <K, V extends Comparable<V>> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, List<V>>>> smallestPerKey(int count) {
        return Combine.perKey(Top.smallestFn(count));
    }

    public static <K, V extends Comparable<V>> Combine.PerKey<K, V, List<V>> largestPerKey(int count) {
        return Combine.perKey(Top.largestFn(count));
    }

    private static class BoundedHeapCoder<T, ComparatorT extends Comparator<T> & Serializable>
    extends CustomCoder<BoundedHeap<T, ComparatorT>> {
        private final Coder<List<T>> listCoder;
        private final ComparatorT compareFn;
        private final int maximumSize;

        public BoundedHeapCoder(int maximumSize, ComparatorT compareFn, Coder<T> elementCoder) {
            this.listCoder = ListCoder.of(elementCoder);
            this.compareFn = compareFn;
            this.maximumSize = maximumSize;
        }

        @Override
        public void encode(BoundedHeap<T, ComparatorT> value, OutputStream outStream) throws CoderException, IOException {
            this.listCoder.encode(((BoundedHeap)value).asList(), outStream);
        }

        @Override
        public BoundedHeap<T, ComparatorT> decode(InputStream inStream) throws CoderException, IOException {
            return new BoundedHeap(this.maximumSize, (Comparator)this.compareFn, this.listCoder.decode(inStream), null);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            BoundedHeapCoder.verifyDeterministic(this, "HeapCoder requires a deterministic list coder", this.listCoder);
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(BoundedHeap<T, ComparatorT> value) {
            return this.listCoder.isRegisterByteSizeObserverCheap(((BoundedHeap)value).asList());
        }

        @Override
        public void registerByteSizeObserver(BoundedHeap<T, ComparatorT> value, ElementByteSizeObserver observer) throws Exception {
            this.listCoder.registerByteSizeObserver(((BoundedHeap)value).asList(), observer);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof BoundedHeapCoder)) {
                return false;
            }
            BoundedHeapCoder that = (BoundedHeapCoder)other;
            return Objects.equals(this.compareFn, that.compareFn) && Objects.equals(this.listCoder, that.listCoder) && this.maximumSize == that.maximumSize;
        }

        public int hashCode() {
            return Objects.hash(this.compareFn, this.listCoder, this.maximumSize);
        }
    }

    static class BoundedHeap<T, ComparatorT extends Comparator<T> & Serializable>
    implements Combine.AccumulatingCombineFn.Accumulator<T, BoundedHeap<T, ComparatorT>, List<T>> {
        @Nullable
        private PriorityQueue<T> asQueue;
        @Nullable
        private List<T> asList;
        private final ComparatorT compareFn;
        private final int maximumSize;

        private BoundedHeap(int maximumSize, ComparatorT compareFn, List<T> asList) {
            this.maximumSize = maximumSize;
            this.asList = asList;
            this.compareFn = compareFn;
        }

        @Override
        public void addInput(T value) {
            this.maybeAddInput(value);
        }

        private boolean maybeAddInput(T value) {
            if (this.maximumSize == 0) {
                return false;
            }
            if (this.asQueue == null) {
                this.asQueue = new PriorityQueue(this.maximumSize, this.compareFn);
                for (T item : this.asList) {
                    this.asQueue.add(item);
                }
                this.asList = null;
            }
            if (this.asQueue.size() < this.maximumSize) {
                this.asQueue.add(value);
                return true;
            }
            if (this.compareFn.compare(value, this.asQueue.peek()) > 0) {
                this.asQueue.poll();
                this.asQueue.add(value);
                return true;
            }
            return false;
        }

        @Override
        public void mergeAccumulator(BoundedHeap<T, ComparatorT> accumulator) {
            for (T value : super.asList()) {
                if (!this.maybeAddInput(value)) break;
            }
        }

        @Override
        public List<T> extractOutput() {
            return this.asList();
        }

        private List<T> asList() {
            if (this.asList == null) {
                ArrayList<T> smallestFirstList = Lists.newArrayListWithCapacity(this.asQueue.size());
                while (!this.asQueue.isEmpty()) {
                    smallestFirstList.add(this.asQueue.poll());
                }
                this.asList = Lists.reverse(smallestFirstList);
                this.asQueue = null;
            }
            return this.asList;
        }

        /* synthetic */ BoundedHeap(int x0, Comparator x1, List x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class TopCombineFn<T, ComparatorT extends Comparator<T> & Serializable>
    extends Combine.AccumulatingCombineFn<T, BoundedHeap<T, ComparatorT>, List<T>>
    implements NameUtils.NameOverride {
        private final int count;
        private final ComparatorT compareFn;

        public TopCombineFn(int count, ComparatorT compareFn) {
            Preconditions.checkArgument(count >= 0, "count must be >= 0 (not %s)", count);
            this.count = count;
            this.compareFn = compareFn;
        }

        @Override
        public String getNameOverride() {
            return String.format("Top(%s)", NameUtils.approximateSimpleName(this.compareFn));
        }

        @Override
        public BoundedHeap<T, ComparatorT> createAccumulator() {
            return new BoundedHeap(this.count, (Comparator)this.compareFn, new ArrayList(), null);
        }

        @Override
        public Coder<BoundedHeap<T, ComparatorT>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return new BoundedHeapCoder<T, ComparatorT>(this.count, this.compareFn, inputCoder);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("count", this.count).withLabel("Top Count")).add(DisplayData.item("comparer", this.compareFn.getClass()).withLabel("Record Comparer"));
        }

        @Override
        public String getIncompatibleGlobalWindowErrorMessage() {
            return "Default values are not supported in Top.[of, smallest, largest]() if the input PCollection is not windowed by GlobalWindows. Instead, use Top.[of, smallest, largest]().withoutDefaults() to output an empty PCollection if the input PCollection is empty, or Top.[of, smallest, largest]().asSingletonView() to get a PCollection containing the empty list if the input PCollection is empty.";
        }
    }

    public static class Reversed<T extends Comparable<? super T>>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T a, T b) {
            return b.compareTo(a);
        }
    }

    @Deprecated
    public static class Smallest<T extends Comparable<? super T>>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T a, T b) {
            return b.compareTo(a);
        }
    }

    public static class Natural<T extends Comparable<? super T>>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T a, T b) {
            return a.compareTo(b);
        }
    }

    @Deprecated
    public static class Largest<T extends Comparable<? super T>>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T a, T b) {
            return a.compareTo(b);
        }
    }
}

